/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit.cleanup;

import org.dbunit.database.DatabaseConnection;
import org.jboss.arquillian.persistence.CleanupStrategy;
import org.jboss.arquillian.persistence.dbunit.cleanup.CleanupStrategyExecutor;
import org.jboss.arquillian.persistence.dbunit.cleanup.SeededDataOnlyCleanupStrategyExecutor;
import org.jboss.arquillian.persistence.dbunit.cleanup.StrictCleanupStrategyExecutor;
import org.jboss.arquillian.persistence.dbunit.cleanup.UsedTablesOnlyCleanupStrategyExecutor;
import org.jboss.arquillian.persistence.dbunit.configuration.DBUnitConfiguration;
import org.jboss.arquillian.persistence.dbunit.dataset.DataSetRegister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanupStrategyProvider
implements CleanupStrategy.StrategyProvider<CleanupStrategyExecutor> {
    private final DatabaseConnection connection;
    private final DataSetRegister register;
    private final DBUnitConfiguration dbUnitConfiguration;

    public CleanupStrategyProvider(DatabaseConnection connection, DataSetRegister register, DBUnitConfiguration dbUnitConfiguration) {
        this.connection = connection;
        this.register = register != null ? register : new DataSetRegister();
        this.dbUnitConfiguration = dbUnitConfiguration;
    }

    public CleanupStrategyExecutor strictStrategy() {
        return new StrictCleanupStrategyExecutor(this.connection, this.dbUnitConfiguration);
    }

    public CleanupStrategyExecutor usedTablesOnlyStrategy() {
        return new UsedTablesOnlyCleanupStrategyExecutor(this.connection, this.register, this.dbUnitConfiguration);
    }

    public CleanupStrategyExecutor usedRowsOnlyStrategy() {
        return new SeededDataOnlyCleanupStrategyExecutor(this.connection, this.register, this.dbUnitConfiguration);
    }

    public CleanupStrategyExecutor defaultStrategy() {
        return new StrictCleanupStrategyExecutor(this.connection, this.dbUnitConfiguration);
    }
}

