/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit.cleanup;

import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.operation.DatabaseOperation;
import org.jboss.arquillian.persistence.dbunit.DataSetUtils;
import org.jboss.arquillian.persistence.dbunit.cleanup.CleanupStrategyExecutor;
import org.jboss.arquillian.persistence.dbunit.configuration.DBUnitConfiguration;
import org.jboss.arquillian.persistence.dbunit.exception.DBUnitDataSetHandlingException;
import org.jboss.arquillian.persistence.dbunit.filter.TableFilterResolver;
import org.jboss.arquillian.persistence.spi.dbunit.filter.TableFilterProvider;

public class StrictCleanupStrategyExecutor
implements CleanupStrategyExecutor {
    private final DatabaseConnection connection;
    private final DBUnitConfiguration dbUnitConfiguration;

    public StrictCleanupStrategyExecutor(DatabaseConnection connection, DBUnitConfiguration dbUnitConfiguration) {
        this.connection = connection;
        this.dbUnitConfiguration = dbUnitConfiguration;
    }

    public void cleanupDatabase(String ... tablesToExclude) {
        try {
            IDataSet dataSet = DataSetUtils.excludeTables(this.connection.createDataSet(), tablesToExclude);
            if (this.dbUnitConfiguration.isFilterTables()) {
                TableFilterProvider tableFilterProvider = new TableFilterResolver(this.dbUnitConfiguration).resolve();
                ITableFilter tableFilter = tableFilterProvider.provide((IDatabaseConnection)this.connection, dataSet.getTableNames());
                dataSet = new FilteredDataSet(tableFilter, dataSet);
            }
            DatabaseOperation.DELETE_ALL.execute((IDatabaseConnection)this.connection, dataSet);
        }
        catch (Exception e) {
            throw new DBUnitDataSetHandlingException("Unable to clean database.", e);
        }
    }
}

