/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.persistence.core.data.descriptor.DtdFileResourceDescriptor;
import org.jboss.arquillian.persistence.core.data.descriptor.Format;
import org.jboss.arquillian.persistence.core.data.descriptor.ResourceDescriptor;
import org.jboss.arquillian.persistence.core.metadata.AnnotationInspector;
import org.jboss.arquillian.persistence.core.metadata.MetadataExtractor;
import org.jboss.arquillian.persistence.core.metadata.PersistenceExtensionEnabler;
import org.jboss.arquillian.persistence.dbunit.api.CustomColumnFilter;
import org.jboss.arquillian.persistence.dbunit.configuration.DBUnitConfiguration;
import org.jboss.arquillian.persistence.dbunit.data.descriptor.DataSetResourceDescriptor;
import org.jboss.arquillian.persistence.dbunit.data.provider.DataSetProvider;
import org.jboss.arquillian.persistence.dbunit.data.provider.ExpectedDataSetProvider;
import org.jboss.arquillian.persistence.dbunit.dataset.xml.DtdResolver;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUnitDataSetsTestArchiveEnricher
implements ApplicationArchiveProcessor {
    @Inject
    Instance<DBUnitConfiguration> dbunitConfigurationInstance;

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        PersistenceExtensionEnabler persistenceExtensionEnabler = new PersistenceExtensionEnabler(testClass);
        if (!persistenceExtensionEnabler.shouldPersistenceExtensionBeActivated()) {
            return;
        }
        this.addCustomColumnFilters(applicationArchive, testClass);
        this.addResources(applicationArchive, testClass);
    }

    private void addResources(Archive<?> applicationArchive, TestClass testClass) {
        Set<ResourceDescriptor<?>> allDataResources = this.fetchAllDataResources(testClass);
        if (!allDataResources.isEmpty()) {
            this.addResources(applicationArchive, allDataResources);
        }
    }

    private void addCustomColumnFilters(Archive<?> applicationArchive, TestClass testClass) {
        block4: {
            Collection allCustomAnnotations;
            block3: {
                AnnotationInspector inspector = new AnnotationInspector(testClass, CustomColumnFilter.class);
                allCustomAnnotations = inspector.fetchAll();
                if (allCustomAnnotations.isEmpty()) {
                    return;
                }
                if (!(applicationArchive instanceof EnterpriseArchive)) break block3;
                JavaArchive customFiltersArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"arquillian-persistence-dbunit-custom-filters.jar");
                for (CustomColumnFilter filter : allCustomAnnotations) {
                    customFiltersArchive.addClasses((Class[])filter.value());
                    ((EnterpriseArchive)EnterpriseArchive.class.cast(applicationArchive)).addAsLibrary((Archive)customFiltersArchive);
                }
                break block4;
            }
            if (!(applicationArchive instanceof ClassContainer)) break block4;
            for (CustomColumnFilter filter : allCustomAnnotations) {
                ((ClassContainer)ClassContainer.class.cast(applicationArchive)).addClasses((Class[])filter.value());
            }
        }
    }

    private Set<ResourceDescriptor<?>> fetchAllDataResources(TestClass testClass) {
        HashSet allDataSets = new HashSet();
        DataSetProvider dataSetProvider = new DataSetProvider(new MetadataExtractor(testClass), (DBUnitConfiguration)((Object)this.dbunitConfigurationInstance.get()));
        ExpectedDataSetProvider expectedDataSetProvider = new ExpectedDataSetProvider(new MetadataExtractor(testClass), (DBUnitConfiguration)((Object)this.dbunitConfigurationInstance.get()));
        allDataSets.addAll(dataSetProvider.getDescriptors(testClass));
        allDataSets.addAll(expectedDataSetProvider.getDescriptors(testClass));
        allDataSets.addAll(this.extractDtds(dataSetProvider.getDescriptors(testClass)));
        allDataSets.addAll(this.extractDtds(expectedDataSetProvider.getDescriptors(testClass)));
        return allDataSets;
    }

    private void addResources(Archive<?> applicationArchive, Set<ResourceDescriptor<?>> allDataResources) {
        List<String> resources = this.extractPaths(allDataResources);
        if (EnterpriseArchive.class.isInstance(applicationArchive)) {
            ((EnterpriseArchive)applicationArchive).addAsLibrary((Archive)this.createArchiveWithResources(resources));
        } else if (ResourceContainer.class.isInstance(applicationArchive)) {
            this.addResourcesToApplicationArchive((ResourceContainer)applicationArchive, resources);
        } else {
            throw new RuntimeException("Unsupported archive type " + applicationArchive.getClass().getName());
        }
    }

    private void addResourcesToApplicationArchive(ResourceContainer<?> applicationArchive, List<String> resourcePaths) {
        for (String path : resourcePaths) {
            applicationArchive.addAsResource(path);
        }
    }

    private JavaArchive createArchiveWithResources(Collection<String> resourcePaths) {
        JavaArchive dataSetsArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"arquillian-persistence-datasets.jar");
        for (String path : resourcePaths) {
            dataSetsArchive.addAsResource(path);
        }
        return dataSetsArchive;
    }

    private List<String> extractPaths(Collection<? extends ResourceDescriptor<?>> descriptors) {
        ArrayList<String> paths = new ArrayList<String>(descriptors.size());
        for (ResourceDescriptor<?> descriptor : descriptors) {
            if (!Format.isFileType((Format)descriptor.getFormat())) continue;
            paths.add(descriptor.getLocation());
        }
        return paths;
    }

    private Collection<DtdFileResourceDescriptor> extractDtds(Collection<DataSetResourceDescriptor> descriptors) {
        ArrayList<DtdFileResourceDescriptor> dtds = new ArrayList<DtdFileResourceDescriptor>();
        DtdResolver dtdResolver = new DtdResolver();
        for (DataSetResourceDescriptor dataSet : descriptors) {
            String dtd;
            if (!Format.XML.equals((Object)dataSet.getFormat()) || (dtd = dtdResolver.resolveDtdLocationFullPath(dataSet.getLocation())) == null) continue;
            dtds.add(new DtdFileResourceDescriptor(dtd));
        }
        return dtds;
    }
}

