/*
 * JBoss, Home of Professional Open Source
 * Copyright 2011 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.arquillian.persistence.data;


/**
 *
 * Contains information about the file - it's name and {@link Format format}.
 *
 * @author <a href="mailto:bartosz.majsak@gmail.com">Bartosz Majsak</a>
 *
 */
public class DataSetDescriptor
{

   private final String fileLocation;

   private final Format format;

   public DataSetDescriptor(String fileLocation, Format format)
   {
      this.fileLocation = fileLocation;
      this.format = format;
   }

   public String getFileLocation()
   {
      return fileLocation;
   }

   public Format getFormat()
   {
      return format;
   }

   @Override
   public boolean equals(Object obj)
   {
      if (this == obj)
      {
         return true;
      }

      if (!(obj instanceof DataSetDescriptor))
      {
         return false;
      }

      final DataSetDescriptor other = (DataSetDescriptor) obj;
      return fileLocation.equals(other.fileLocation) && format.equals(other.format);
   }

   @Override
   public int hashCode()
   {
      final int prime = 17;
      int result = 1;
      result = prime * result + ((fileLocation == null) ? 0 : fileLocation.hashCode());
      result = prime * result + ((format == null) ? 0 : format.hashCode());
      return result;
   }

   @Override
   public String toString()
   {
      return this.getClass().getSimpleName() + "@" + hashCode() + "[" + fileLocation + ", " + format + "]";
   }

}
