/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.integration.persistence.example;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.jboss.arquillian.integration.persistence.example.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="useraccount")
public class UserAccount
implements Serializable {
    private static final long serialVersionUID = -5070859529655572725L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Basic
    @NotNull
    @Size(min=3, max=32)
    private String username;
    @Basic
    @NotNull
    @Size(min=8)
    private String password;
    @Basic
    @NotNull
    @Size(max=128)
    private String firstname;
    @Basic
    @NotNull
    @Size(max=128)
    private String lastname;
    @Basic
    @Size(max=128)
    private String nickname;
    @OneToMany(cascade={CascadeType.ALL})
    private Set<Address> addresses = new HashSet<Address>();

    protected UserAccount() {
    }

    public UserAccount(String firstName, String lastName, String username, String password) {
        this.firstname = firstName;
        this.lastname = lastName;
        this.username = username;
        this.password = password;
    }

    public void addAddress(Address address) {
        this.addresses.add(address);
    }

    public Long getId() {
        return this.id;
    }

    void setId(Long id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public Set<Address> getAddresses() {
        return Collections.unmodifiableSet(this.addresses);
    }

    void setAddresses(Set<Address> addresses) {
        this.addresses = addresses;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }
}

