/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.persistence.datasource;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.persistence.spi.datasource.DataSourceProvider;
import org.jboss.arquillian.spring.integration.context.RemoteTestScopeApplicationContext;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class ApplicationContextDataSourceProvider
implements DataSourceProvider {
    private static final Logger log = Logger.getLogger(ApplicationContextDataSourceProvider.class.getName());
    @Inject
    private Instance<RemoteTestScopeApplicationContext> applicationContextInstance;

    public DataSource lookupDataSource(String dataSourceName) {
        try {
            return (DataSource)this.getApplicationContext().getBean(dataSourceName, DataSource.class);
        }
        catch (BeansException e) {
            log.log(Level.WARNING, String.format("The data source with name '%s' could not be lookup due to an unexpected error.", dataSourceName), e);
            return null;
        }
    }

    private ApplicationContext getApplicationContext() {
        return ((RemoteTestScopeApplicationContext)this.applicationContextInstance.get()).getApplicationContext();
    }
}

