/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.rest.app;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import org.jboss.arquillian.extension.rest.app.Customer;
import org.jboss.arquillian.extension.rest.app.CustomerResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomerResourceImpl
implements CustomerResource {
    @Context
    private ServletContext servletContext;

    @Override
    public List<Customer> getAllCustomers() {
        return this.findAllCustomers();
    }

    @Override
    public Customer getCustomerById(@PathParam(value="id") long id) {
        return this.findCustomerById(id);
    }

    @Override
    public Customer banCustomer(long id) {
        Customer customer = this.findCustomerById(id);
        if (null == customer) {
            return null;
        }
        customer.setBanned(true);
        return customer;
    }

    @Override
    public Customer createCustomer(Customer customer) {
        this.findAllCustomers();
        customer.setId(this.nextId());
        return customer;
    }

    private List<Customer> findAllCustomers() {
        ArrayList<Customer> customers;
        String attributeName = "customers";
        Object attribute = this.servletContext.getAttribute("customers");
        if (!(attribute instanceof List)) {
            customers = new ArrayList<Customer>();
            customers.add(new Customer(this.nextId(), "Acme Corporation"));
            customers.add(new Customer(this.nextId(), "Don"));
            this.servletContext.setAttribute("customers", customers);
        } else {
            customers = (ArrayList<Customer>)attribute;
        }
        return customers;
    }

    private Customer findCustomerById(long id) {
        for (Customer customer : this.findAllCustomers()) {
            if (id != customer.getId()) continue;
            return customer;
        }
        return null;
    }

    private long nextId() {
        String attributeName = "customerIdSequence";
        Object attribute = this.servletContext.getAttribute("customerIdSequence");
        long newValue = attribute instanceof Long ? (Long)attribute + 1L : 1L;
        this.servletContext.setAttribute("customerIdSequence", (Object)newValue);
        return newValue;
    }
}

