/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.rest.warp.impl.resteasy.integration;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.arquillian.extension.rest.warp.api.HttpMethod;
import org.jboss.arquillian.extension.rest.warp.api.HttpResponse;
import org.jboss.arquillian.extension.rest.warp.spi.HttpRequestImpl;
import org.jboss.arquillian.extension.rest.warp.spi.HttpResponseImpl;
import org.jboss.arquillian.extension.rest.warp.spi.MultivaluedMapImpl;
import org.jboss.arquillian.extension.rest.warp.spi.RestContextBuilder;
import org.jboss.arquillian.extension.rest.warp.spi.RestContextImpl;
import org.jboss.arquillian.extension.rest.warp.spi.SecurityContextImpl;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.HttpRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ResteasyContextBuilder
implements RestContextBuilder {
    private static final String BUILDER_ATTRIBUTE_NAME = ResteasyContextBuilder.class.getName();
    private final HttpRequest httpRequest;
    private final RestContextImpl restContext;
    private Object requestEntity;
    private MediaType responseMediaType;
    private ServerResponse serverResponse;
    private SecurityContext securityContext;

    private ResteasyContextBuilder(HttpRequest httpRequest) {
        Validate.notNull((Object)httpRequest, (String)"The 'httpRequest' can not be null.");
        this.httpRequest = httpRequest;
        this.restContext = this.getRestContext();
    }

    public static ResteasyContextBuilder buildContext(HttpRequest httpRequest) {
        return ResteasyContextBuilder.getRestContextBuilder(httpRequest);
    }

    public ResteasyContextBuilder setResponseMediaType(MediaType responseMediaType) {
        this.responseMediaType = responseMediaType;
        return this;
    }

    public ResteasyContextBuilder setServerResponse(ServerResponse serverResponse) {
        this.serverResponse = serverResponse;
        return this;
    }

    public ResteasyContextBuilder setRequestEntity(Object entity) {
        this.requestEntity = entity;
        return this;
    }

    public ResteasyContextBuilder setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
        return this;
    }

    public void build() {
        this.restContext.setHttpRequest(this.buildHttpRequest());
        this.restContext.setHttpResponse(this.buildHttpResponse());
        this.restContext.setResponse((Response)this.serverResponse);
        this.restContext.setSecurityContext(this.buildSecurityContext());
    }

    private org.jboss.arquillian.extension.rest.warp.api.HttpRequest buildHttpRequest() {
        HttpRequestImpl request = new HttpRequestImpl();
        if (this.httpRequest != null) {
            request.setContentType(ResteasyContextBuilder.getMediaTypeName(this.httpRequest.getHttpHeaders().getMediaType()));
            request.setEntity(this.requestEntity);
            request.setMethod(ResteasyContextBuilder.getHttpMethod(this.httpRequest.getHttpMethod()));
            request.setHeaders((MultivaluedMap)new MultivaluedMapImpl(this.httpRequest.getHttpHeaders().getRequestHeaders()));
        }
        return request;
    }

    private HttpResponse buildHttpResponse() {
        HttpResponseImpl response = new HttpResponseImpl();
        if (this.serverResponse != null) {
            response.setContentType(ResteasyContextBuilder.getMediaTypeName(this.responseMediaType));
            response.setStatusCode(this.serverResponse.getStatus());
            response.setEntity(this.serverResponse.getEntity());
            response.setHeaders(this.serverResponse.getMetadata());
        }
        return response;
    }

    private org.jboss.arquillian.extension.rest.warp.api.SecurityContext buildSecurityContext() {
        SecurityContextImpl securityContext = new SecurityContextImpl();
        if (this.securityContext != null) {
            securityContext.setPrincipal(this.securityContext.getUserPrincipal());
            securityContext.setAuthenticationScheme(this.securityContext.getAuthenticationScheme());
        }
        return securityContext;
    }

    private static String getMediaTypeName(MediaType mediaType) {
        return mediaType != null ? mediaType.toString() : null;
    }

    private static HttpMethod getHttpMethod(String methodName) {
        return Enum.valueOf(HttpMethod.class, methodName.toUpperCase());
    }

    private List<String> getHttpValueList(List<Object> values) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object val : values) {
            result.add(val.toString());
        }
        return result;
    }

    private static ResteasyContextBuilder getRestContextBuilder(HttpRequest httpRequest) {
        ResteasyContextBuilder resteasyContextBuilder = (ResteasyContextBuilder)httpRequest.getAttribute(BUILDER_ATTRIBUTE_NAME);
        if (resteasyContextBuilder == null) {
            resteasyContextBuilder = new ResteasyContextBuilder(httpRequest);
            httpRequest.setAttribute(BUILDER_ATTRIBUTE_NAME, (Object)resteasyContextBuilder);
        }
        return resteasyContextBuilder;
    }

    private RestContextImpl getRestContext() {
        RestContextImpl restContext = (RestContextImpl)this.httpRequest.getAttribute("org.jboss.arquillian.warp.extension.jaxrs.spi.WARP_REST_ATTRIBUTE");
        if (restContext == null) {
            restContext = new RestContextImpl();
            this.httpRequest.setAttribute("org.jboss.arquillian.warp.extension.jaxrs.spi.WARP_REST_ATTRIBUTE", (Object)restContext);
        }
        return restContext;
    }
}

