/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.spring.embedded;

import org.jboss.arquillian.container.spring.embedded.ContextClassLoaderManager;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.classloader.ShrinkWrapClassLoader;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ContextClassLoaderManagerTestCase {
    private ContextClassLoaderManager instance;
    private ShrinkWrapClassLoader shrinkWrapClassLoader;
    private ClassLoader threadClassLoader;

    @Before
    public void setUp() {
        this.threadClassLoader = Thread.currentThread().getContextClassLoader();
        this.shrinkWrapClassLoader = new ShrinkWrapClassLoader(new Archive[]{(Archive)ShrinkWrap.create(JavaArchive.class)});
        this.instance = new ContextClassLoaderManager(this.shrinkWrapClassLoader);
    }

    @After
    public void tearDown() {
        Thread.currentThread().setContextClassLoader(this.threadClassLoader);
    }

    @Test
    public void testCtor() {
        this.instance = new ContextClassLoaderManager(this.shrinkWrapClassLoader);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCtorNull() {
        new ContextClassLoaderManager(null);
    }

    @Test
    public void testEnable() {
        this.instance.enable();
        Assert.assertEquals((String)"The class loader hasn't been set.", (Object)this.shrinkWrapClassLoader, (Object)Thread.currentThread().getContextClassLoader());
    }

    @Test
    public void testDisable() {
        this.instance.enable();
        this.instance.disable();
        Assert.assertEquals((String)"The class loader hasn't been restored.", (Object)this.threadClassLoader, (Object)Thread.currentThread().getContextClassLoader());
    }
}

