/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.spring.embedded;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jboss.arquillian.container.spring.embedded.SpringEmbeddedApplicationContextLifeCycleHandler;
import org.jboss.arquillian.container.spring.embedded.TestReflectionHelper;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.spring.integration.context.ApplicationContextDestroyer;
import org.jboss.arquillian.spring.integration.context.RemoteApplicationContextProducer;
import org.jboss.arquillian.spring.integration.context.RemoteTestScopeApplicationContext;
import org.jboss.arquillian.spring.integration.context.TestScopeApplicationContext;
import org.jboss.arquillian.spring.integration.event.ApplicationContextCreatedEvent;
import org.jboss.arquillian.spring.integration.event.ApplicationContextDestroyedEvent;
import org.jboss.arquillian.spring.integration.test.annotation.ContextLifeCycle;
import org.jboss.arquillian.spring.integration.test.annotation.ContextLifeCycleMode;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class SpringEmbeddedApplicationContextLifeCycleHandlerTestCase {
    private static final Object TEST_OBJECT = new TestCaseTest();
    private SpringEmbeddedApplicationContextLifeCycleHandler instance;
    private RemoteApplicationContextProducer supportedApplicationContextProducer;
    private RemoteApplicationContextProducer notSupportedApplicationContextProducer;
    private ApplicationContextDestroyer applicationContextDestroyer;
    private TestClass testClass;
    private Event<ApplicationContextCreatedEvent> mockApplicationContextCreatedEvent;
    private Event<ApplicationContextDestroyedEvent> mockApplicationContextDestroyedEvent;
    private Method testMethod;

    @org.junit.Before
    public void setUp() throws Exception {
        this.testClass = new TestClass(TEST_OBJECT.getClass());
        this.testMethod = TEST_OBJECT.getClass().getMethod("testMethod", new Class[0]);
        this.instance = new SpringEmbeddedApplicationContextLifeCycleHandler();
        this.supportedApplicationContextProducer = (RemoteApplicationContextProducer)Mockito.mock(RemoteApplicationContextProducer.class);
        Mockito.when((Object)this.supportedApplicationContextProducer.supports((TestClass)Matchers.any(TestClass.class))).thenReturn((Object)true);
        Mockito.when((Object)this.supportedApplicationContextProducer.createApplicationContext((TestClass)Matchers.any(TestClass.class))).thenReturn((Object)new RemoteTestScopeApplicationContext((ApplicationContext)new GenericApplicationContext(), this.testClass, true));
        this.notSupportedApplicationContextProducer = (RemoteApplicationContextProducer)Mockito.mock(RemoteApplicationContextProducer.class);
        Mockito.when((Object)this.notSupportedApplicationContextProducer.supports((TestClass)Matchers.any(TestClass.class))).thenReturn((Object)false);
        this.applicationContextDestroyer = (ApplicationContextDestroyer)Mockito.mock(ApplicationContextDestroyer.class);
        this.mockApplicationContextCreatedEvent = (Event)Mockito.mock(Event.class);
        TestReflectionHelper.setFieldValue(this.instance, "applicationContextEvent", this.mockApplicationContextCreatedEvent);
    }

    @Test
    public void testInitApplicationContextSupportedBeforeClass() throws Exception {
        ArrayList<RemoteApplicationContextProducer> producers = new ArrayList<RemoteApplicationContextProducer>();
        producers.add(this.notSupportedApplicationContextProducer);
        producers.add(this.supportedApplicationContextProducer);
        ServiceLoader serviceLoader = (ServiceLoader)Mockito.mock(ServiceLoader.class);
        Mockito.when((Object)serviceLoader.all(RemoteApplicationContextProducer.class)).thenReturn(producers);
        Instance mockServiceLoader = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockServiceLoader.get()).thenReturn((Object)serviceLoader);
        TestReflectionHelper.setFieldValue(this.instance, "serviceLoaderInstance", mockServiceLoader);
        InstanceProducer mockApplicationContext = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "applicationContextInstance", mockApplicationContext);
        this.instance.beforeClass(new BeforeClass(TEST_OBJECT.getClass()));
        ((Event)Mockito.verify(this.mockApplicationContextCreatedEvent)).fire(Matchers.any(ApplicationContextCreatedEvent.class));
        ((InstanceProducer)Mockito.verify((Object)mockApplicationContext)).set((Object)((RemoteTestScopeApplicationContext)Matchers.notNull()));
    }

    @Test
    public void testInitApplicationContextSupportedTestCase() throws Exception {
        ArrayList<RemoteApplicationContextProducer> producers = new ArrayList<RemoteApplicationContextProducer>();
        producers.add(this.notSupportedApplicationContextProducer);
        producers.add(this.supportedApplicationContextProducer);
        ServiceLoader serviceLoader = (ServiceLoader)Mockito.mock(ServiceLoader.class);
        Mockito.when((Object)serviceLoader.all(RemoteApplicationContextProducer.class)).thenReturn(producers);
        Instance mockServiceLoader = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockServiceLoader.get()).thenReturn((Object)serviceLoader);
        TestReflectionHelper.setFieldValue(this.instance, "serviceLoaderInstance", mockServiceLoader);
        InstanceProducer mockApplicationContext = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "applicationContextInstance", mockApplicationContext);
        this.instance.beforeTest(new Before(TEST_OBJECT, this.testMethod));
        ((Event)Mockito.verify(this.mockApplicationContextCreatedEvent)).fire(Matchers.any(ApplicationContextCreatedEvent.class));
        ((InstanceProducer)Mockito.verify((Object)mockApplicationContext)).set((Object)((RemoteTestScopeApplicationContext)Matchers.notNull()));
    }

    @Test
    public void testInitApplicationContextSupportedTestMethod() throws Exception {
        ArrayList<RemoteApplicationContextProducer> producers = new ArrayList<RemoteApplicationContextProducer>();
        producers.add(this.notSupportedApplicationContextProducer);
        producers.add(this.supportedApplicationContextProducer);
        ServiceLoader serviceLoader = (ServiceLoader)Mockito.mock(ServiceLoader.class);
        Mockito.when((Object)serviceLoader.all(RemoteApplicationContextProducer.class)).thenReturn(producers);
        Instance mockServiceLoader = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockServiceLoader.get()).thenReturn((Object)serviceLoader);
        TestReflectionHelper.setFieldValue(this.instance, "serviceLoaderInstance", mockServiceLoader);
        InstanceProducer mockApplicationContext = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "applicationContextInstance", mockApplicationContext);
        this.instance.beforeTest(new Before((Object)new TestMethodTest(), TestMethodTest.class.getMethod("testMethod", new Class[0])));
        ((Event)Mockito.verify(this.mockApplicationContextCreatedEvent)).fire(Matchers.any(ApplicationContextCreatedEvent.class));
        ((InstanceProducer)Mockito.verify((Object)mockApplicationContext)).set((Object)((RemoteTestScopeApplicationContext)Matchers.notNull()));
    }

    @Test
    public void testInitApplicationContextNotSupported() throws Exception {
        ArrayList<RemoteApplicationContextProducer> producers = new ArrayList<RemoteApplicationContextProducer>();
        producers.add(this.notSupportedApplicationContextProducer);
        ServiceLoader serviceLoader = (ServiceLoader)Mockito.mock(ServiceLoader.class);
        Mockito.when((Object)serviceLoader.all(RemoteApplicationContextProducer.class)).thenReturn(producers);
        Instance mockServiceLoader = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockServiceLoader.get()).thenReturn((Object)serviceLoader);
        TestReflectionHelper.setFieldValue(this.instance, "serviceLoaderInstance", mockServiceLoader);
        InstanceProducer mockApplicationContext = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        Mockito.when((Object)mockApplicationContext.get()).thenReturn(null);
        TestReflectionHelper.setFieldValue(this.instance, "applicationContextInstance", mockApplicationContext);
        this.instance.beforeClass(new BeforeClass(TEST_OBJECT.getClass()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockApplicationContextCreatedEvent});
    }

    @Test
    public void testDestroyApplicationContextNoApplicationContext() throws Exception {
        ArrayList<ApplicationContextDestroyer> destroyers = new ArrayList<ApplicationContextDestroyer>();
        destroyers.add(this.applicationContextDestroyer);
        ServiceLoader serviceLoader = (ServiceLoader)Mockito.mock(ServiceLoader.class);
        Mockito.when((Object)serviceLoader.all(ApplicationContextDestroyer.class)).thenReturn(destroyers);
        Instance mockServiceLoader = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockServiceLoader.get()).thenReturn((Object)serviceLoader);
        TestReflectionHelper.setFieldValue(this.instance, "serviceLoaderInstance", mockServiceLoader);
        InstanceProducer mockApplicationContext = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        Mockito.when((Object)mockApplicationContext.get()).thenReturn(null);
        TestReflectionHelper.setFieldValue(this.instance, "applicationContextInstance", mockApplicationContext);
        this.instance.afterTest(new After(TEST_OBJECT, this.testMethod));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.applicationContextDestroyer});
    }

    @Test
    public void testDestroyApplicationContextForTestCase() throws Exception {
        ArrayList<ApplicationContextDestroyer> destroyers = new ArrayList<ApplicationContextDestroyer>();
        destroyers.add(this.applicationContextDestroyer);
        ServiceLoader serviceLoader = (ServiceLoader)Mockito.mock(ServiceLoader.class);
        Mockito.when((Object)serviceLoader.all(ApplicationContextDestroyer.class)).thenReturn(destroyers);
        Instance mockServiceLoader = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockServiceLoader.get()).thenReturn((Object)serviceLoader);
        TestReflectionHelper.setFieldValue(this.instance, "serviceLoaderInstance", mockServiceLoader);
        ApplicationContext applicationContext = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        RemoteTestScopeApplicationContext containerTestScopeApplicationContext = new RemoteTestScopeApplicationContext(applicationContext, new TestClass(Object.class), true);
        InstanceProducer mockApplicationContext = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        Mockito.when((Object)mockApplicationContext.get()).thenReturn((Object)containerTestScopeApplicationContext);
        TestReflectionHelper.setFieldValue(this.instance, "applicationContextInstance", mockApplicationContext);
        this.instance.afterTest(new After(TEST_OBJECT, this.testMethod));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.applicationContextDestroyer});
    }

    @Test
    public void testDestroyApplicationContextForTestMethod() throws Exception {
        ArrayList<ApplicationContextDestroyer> destroyers = new ArrayList<ApplicationContextDestroyer>();
        destroyers.add(this.applicationContextDestroyer);
        ServiceLoader serviceLoader = (ServiceLoader)Mockito.mock(ServiceLoader.class);
        Mockito.when((Object)serviceLoader.all(ApplicationContextDestroyer.class)).thenReturn(destroyers);
        Instance mockServiceLoader = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockServiceLoader.get()).thenReturn((Object)serviceLoader);
        TestReflectionHelper.setFieldValue(this.instance, "serviceLoaderInstance", mockServiceLoader);
        ApplicationContext applicationContext = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        RemoteTestScopeApplicationContext containerTestScopeApplicationContext = new RemoteTestScopeApplicationContext(applicationContext, new TestClass(Object.class), true);
        InstanceProducer mockApplicationContext = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        Mockito.when((Object)mockApplicationContext.get()).thenReturn((Object)containerTestScopeApplicationContext);
        TestReflectionHelper.setFieldValue(this.instance, "applicationContextInstance", mockApplicationContext);
        this.instance.afterTest(new After((Object)new TestMethodTest(), TestMethodTest.class.getMethod("testMethod", new Class[0])));
        ((ApplicationContextDestroyer)Mockito.verify((Object)this.applicationContextDestroyer)).destroyApplicationContext((TestScopeApplicationContext)Matchers.any(TestScopeApplicationContext.class));
    }

    @Test
    public void testDestroyApplicationContextAfterSuite() throws Exception {
        ArrayList<ApplicationContextDestroyer> destroyers = new ArrayList<ApplicationContextDestroyer>();
        destroyers.add(this.applicationContextDestroyer);
        ServiceLoader serviceLoader = (ServiceLoader)Mockito.mock(ServiceLoader.class);
        Mockito.when((Object)serviceLoader.all(ApplicationContextDestroyer.class)).thenReturn(destroyers);
        Instance mockServiceLoader = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockServiceLoader.get()).thenReturn((Object)serviceLoader);
        TestReflectionHelper.setFieldValue(this.instance, "serviceLoaderInstance", mockServiceLoader);
        ApplicationContext applicationContext = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        RemoteTestScopeApplicationContext containerTestScopeApplicationContext = new RemoteTestScopeApplicationContext(applicationContext, new TestClass(Object.class), true);
        InstanceProducer mockApplicationContext = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        Mockito.when((Object)mockApplicationContext.get()).thenReturn((Object)containerTestScopeApplicationContext);
        TestReflectionHelper.setFieldValue(this.instance, "applicationContextInstance", mockApplicationContext);
        this.instance.afterSuite(new AfterSuite());
        ((ApplicationContextDestroyer)Mockito.verify((Object)this.applicationContextDestroyer)).destroyApplicationContext((TestScopeApplicationContext)Matchers.any(TestScopeApplicationContext.class));
    }

    @ContextLifeCycle(value=ContextLifeCycleMode.TEST)
    private static class TestMethodTest {
        private TestMethodTest() {
        }

        @Test
        public void testMethod() {
        }
    }

    @ContextLifeCycle(value=ContextLifeCycleMode.TEST_CASE)
    private static class TestCaseTest {
        private TestCaseTest() {
        }

        @Test
        public void testMethod() {
        }
    }
}

