/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.spring.embedded;

import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spring.embedded.SpringEmbeddedConfiguration;
import org.jboss.arquillian.container.spring.embedded.SpringEmbeddedContainer;
import org.jboss.arquillian.container.spring.embedded.TestReflectionHelper;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SpringEmbeddedContainerTestCase {
    private SpringEmbeddedContainer instance;
    private ClassLoader threadClassLoader;

    @Before
    public void setUp() throws Exception {
        this.threadClassLoader = Thread.currentThread().getContextClassLoader();
        this.instance = new SpringEmbeddedContainer();
        InstanceProducer mockClassLoaderManagerProducer = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "contextClassLoaderManager", mockClassLoaderManagerProducer);
        InstanceProducer mockConfigurationProducer = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "configuration", mockConfigurationProducer);
    }

    @After
    public void tearDown() {
        Thread.currentThread().setContextClassLoader(this.threadClassLoader);
    }

    @Test
    public void testCtor() {
        this.instance = new SpringEmbeddedContainer();
    }

    @Test
    public void testGetConfigurationClass() {
        Assert.assertEquals((String)"Method returned invalid type.", SpringEmbeddedConfiguration.class, (Object)this.instance.getConfigurationClass());
    }

    @Test
    public void testSetup() {
        this.instance.setup(null);
    }

    @Test
    public void testStart() throws Exception {
        this.instance.start();
    }

    @Test
    public void testStop() throws Exception {
        this.instance.stop();
    }

    @Test
    public void testGetDefaultProtocol() throws Exception {
        ProtocolDescription protocolDescription = this.instance.getDefaultProtocol();
        Assert.assertNotNull((String)"Method returned null result.", (Object)protocolDescription);
        Assert.assertEquals((String)"The returned protocol has invalid name.", (Object)"Local", (Object)protocolDescription.getName());
    }

    @Test
    public void testDeployArchive() throws Exception {
        Archive archive = (Archive)ShrinkWrap.create(JavaArchive.class);
        ProtocolMetaData protocolMetaData = this.instance.deploy(archive);
        Assert.assertNotNull((String)"Method returned null result.", (Object)protocolMetaData);
    }

    @Test
    public void testUndeployArchive() throws Exception {
        Archive archive = (Archive)ShrinkWrap.create(JavaArchive.class);
        this.instance.undeploy(archive);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testDeployDescriptor() throws Exception {
        Descriptor descriptor = (Descriptor)Mockito.mock(Descriptor.class);
        this.instance.deploy(descriptor);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUndeployDescriptor() throws Exception {
        Descriptor descriptor = (Descriptor)Mockito.mock(Descriptor.class);
        this.instance.undeploy(descriptor);
    }
}

