/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.spring.client.SpringExtensionConfigurationProducer;
import org.jboss.arquillian.spring.configuration.SpringExtensionConfiguration;
import org.jboss.arquillian.spring.utils.TestReflectionHelper;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class SpringExtensionConfigurationProducerTestCase {
    private SpringExtensionConfigurationProducer instance;

    @Before
    public void setUp() {
        this.instance = new SpringExtensionConfigurationProducer();
    }

    @Test
    public void testInitConfigurationDefault() throws Exception {
        BeforeSuite event = new BeforeSuite();
        ArquillianDescriptor descriptor = (ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class);
        this.injectDescriptor(descriptor);
        InstanceProducer mockProducer = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "extensionConfiguration", mockProducer);
        this.instance.initConfiguration(event);
        ArgumentCaptor argument = ArgumentCaptor.forClass(SpringExtensionConfiguration.class);
        ((InstanceProducer)Mockito.verify((Object)mockProducer)).set(argument.capture());
        Assert.assertNotNull((String)"The result was null.", (Object)argument.getValue());
        Assert.assertTrue((String)"Invalid autopackage property.", (boolean)((SpringExtensionConfiguration)argument.getValue()).isAutoPackaging());
        Assert.assertFalse((String)"Invalid includeSnowdrop property.", (boolean)((SpringExtensionConfiguration)argument.getValue()).isIncludeSnowdrop());
        Assert.assertNull((String)"Invalid springVersion property.", (Object)((SpringExtensionConfiguration)argument.getValue()).getSpringVersion());
        Assert.assertNull((String)"Invalid cglibVersion property.", (Object)((SpringExtensionConfiguration)argument.getValue()).getCglibVersion());
        Assert.assertNull((String)"Invalid snowdropVersion property.", (Object)((SpringExtensionConfiguration)argument.getValue()).getSnowdropVersion());
        Assert.assertNull((String)"Invalid customContextClass property.", (Object)((SpringExtensionConfiguration)argument.getValue()).getCustomContextClass());
        Assert.assertNull((String)"Invalid customAnnotationContextClass property.", (Object)((SpringExtensionConfiguration)argument.getValue()).getCustomAnnotationContextClass());
    }

    @Test
    public void testInitConfiguration() throws Exception {
        BeforeSuite event = new BeforeSuite();
        ArquillianDescriptor descriptor = (ArquillianDescriptor)Descriptors.importAs(ArquillianDescriptor.class).from((InputStream)new FileInputStream(new File("src/test/resources", "arquillian.xml")));
        this.injectDescriptor(descriptor);
        InstanceProducer mockProducer = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "extensionConfiguration", mockProducer);
        this.instance.initConfiguration(event);
        ArgumentCaptor argument = ArgumentCaptor.forClass(SpringExtensionConfiguration.class);
        ((InstanceProducer)Mockito.verify((Object)mockProducer)).set(argument.capture());
        Assert.assertNotNull((String)"The result was null.", (Object)argument.getValue());
        Assert.assertFalse((String)"Invalid autopackage property.", (boolean)((SpringExtensionConfiguration)argument.getValue()).isAutoPackaging());
        Assert.assertTrue((String)"Invalid includeSnowdrop property.", (boolean)((SpringExtensionConfiguration)argument.getValue()).isIncludeSnowdrop());
        Assert.assertEquals((String)"Invalid springVersion property.", (Object)"3.1.1.RELEASE", (Object)((SpringExtensionConfiguration)argument.getValue()).getSpringVersion());
        Assert.assertEquals((String)"Invalid cglibVersion property.", (Object)"2.2.2", (Object)((SpringExtensionConfiguration)argument.getValue()).getCglibVersion());
        Assert.assertEquals((String)"Invalid snowdropVersion property.", (Object)"2.0.3.Final", (Object)((SpringExtensionConfiguration)argument.getValue()).getSnowdropVersion());
        Assert.assertEquals((String)"Invalid customContextClass property.", (Object)"org.springframework.context.support.ClassPathXmlApplicationContext", (Object)((SpringExtensionConfiguration)argument.getValue()).getCustomContextClass());
        Assert.assertEquals((String)"Invalid customAnnotationContextClass property.", (Object)"org.springframework.context.annotation.AnnotationConfigApplicationContext", (Object)((SpringExtensionConfiguration)argument.getValue()).getCustomAnnotationContextClass());
    }

    private void injectDescriptor(ArquillianDescriptor descriptor) throws IllegalAccessException, NoSuchFieldException {
        Instance mockDescriptorInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockDescriptorInstance.get()).thenReturn((Object)descriptor);
        TestReflectionHelper.setFieldValue(this.instance, "descriptor", mockDescriptorInstance);
    }
}

