/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.context;

import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.spring.context.ApplicationContextDestroyer;
import org.jboss.arquillian.spring.context.TestScopeApplicationContext;
import org.jboss.arquillian.spring.model.PlainClass;
import org.jboss.arquillian.spring.utils.TestReflectionHelper;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ApplicationContextDestroyerTestCase {
    private ApplicationContextDestroyer instance;

    @Before
    public void setUp() {
        this.instance = new ApplicationContextDestroyer();
    }

    @Test
    public void testDestroyApplicationContextFalse() throws Exception {
        AfterClass event = new AfterClass(PlainClass.class);
        Instance mockInstance = (Instance)Mockito.mock(Instance.class);
        TestReflectionHelper.setFieldValue(this.instance, "testApplicationContext", mockInstance);
        ConfigurableApplicationContext mockApplicationContext = (ConfigurableApplicationContext)Mockito.mock(ConfigurableApplicationContext.class);
        Mockito.when((Object)mockInstance.get()).thenReturn((Object)new TestScopeApplicationContext((ApplicationContext)mockApplicationContext, false));
        this.instance.destroyApplicationContext(event);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockApplicationContext});
    }

    @Test
    public void testDestroyApplicationContextTrue() throws Exception {
        AfterClass event = new AfterClass(PlainClass.class);
        Instance mockInstance = (Instance)Mockito.mock(Instance.class);
        TestReflectionHelper.setFieldValue(this.instance, "testApplicationContext", mockInstance);
        ConfigurableApplicationContext mockApplicationContext = (ConfigurableApplicationContext)Mockito.mock(ConfigurableApplicationContext.class);
        Mockito.when((Object)mockInstance.get()).thenReturn((Object)new TestScopeApplicationContext((ApplicationContext)mockApplicationContext, true));
        this.instance.destroyApplicationContext(event);
        ((ConfigurableApplicationContext)Mockito.verify((Object)mockApplicationContext)).close();
    }
}

