/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.deployer.client;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.spring.deployer.client.SpringProtocolArchiveProcessor;
import org.jboss.arquillian.spring.deployer.configuration.SpringDeployerConfiguration;
import org.jboss.arquillian.spring.deployer.dependency.AbstractDependencyResolver;
import org.jboss.arquillian.spring.deployer.dependency.MavenDependencyBuilder;
import org.jboss.arquillian.spring.deployer.utils.TestReflectionHelper;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SpringProtocolArchiveProcessorTestCase {
    private SpringProtocolArchiveProcessor instance;

    @Before
    public void setUp() {
        this.instance = new SpringProtocolArchiveProcessor();
    }

    @Test
    public void testProcessJarAutoPackageTrue() throws Exception {
        this.injectConfiguration(true);
        JavaArchive deploymentArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"deployment.jar");
        JavaArchive auxiliaryArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"auxiliary.jar");
        WebArchive protocolArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"protocol.war");
        ArrayList<JavaArchive> auxiliaryArchives = new ArrayList<JavaArchive>();
        auxiliaryArchives.add(auxiliaryArchive);
        TestDeployment testDeployment = new TestDeployment(null, (Archive)deploymentArchive, auxiliaryArchives);
        this.instance.process(testDeployment, (Archive)protocolArchive);
        this.assertDependencies(protocolArchive, true);
    }

    @Test
    public void testProcessJarAutoPackageFalse() throws Exception {
        this.injectConfiguration(false);
        JavaArchive deploymentArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"deployment.jar");
        JavaArchive auxiliaryArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"auxiliary.jar");
        WebArchive protocolArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"protocol.war");
        ArrayList<JavaArchive> auxiliaryArchives = new ArrayList<JavaArchive>();
        auxiliaryArchives.add(auxiliaryArchive);
        TestDeployment testDeployment = new TestDeployment(null, (Archive)deploymentArchive, auxiliaryArchives);
        this.instance.process(testDeployment, (Archive)protocolArchive);
        this.assertDependencies(protocolArchive, false);
    }

    @Test
    public void testProcessWarAutoPackageTrue() throws Exception {
        this.injectConfiguration(true);
        WebArchive deploymentArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"deployment.war");
        JavaArchive auxiliaryArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"auxiliary.jar");
        WebArchive protocolArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"protocol.war");
        ArrayList<JavaArchive> auxiliaryArchives = new ArrayList<JavaArchive>();
        auxiliaryArchives.add(auxiliaryArchive);
        TestDeployment testDeployment = new TestDeployment(null, (Archive)deploymentArchive, auxiliaryArchives);
        this.instance.process(testDeployment, (Archive)protocolArchive);
        this.assertDependencies(deploymentArchive, true);
    }

    @Test
    public void testProcessWarAutoPackageFalse() throws Exception {
        this.injectConfiguration(false);
        WebArchive deploymentArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"deployment.war");
        JavaArchive auxiliaryArchive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"auxiliary.jar");
        WebArchive protocolArchive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"protocol.war");
        ArrayList<JavaArchive> auxiliaryArchives = new ArrayList<JavaArchive>();
        auxiliaryArchives.add(auxiliaryArchive);
        TestDeployment testDeployment = new TestDeployment(null, (Archive)deploymentArchive, auxiliaryArchives);
        this.instance.process(testDeployment, (Archive)protocolArchive);
        this.assertDependencies(deploymentArchive, false);
    }

    private void injectConfiguration(boolean autoPackage) throws Exception {
        SpringDeployerConfiguration deployerConfiguration = new SpringDeployerConfiguration();
        deployerConfiguration.setAutoPackaging(autoPackage);
        Instance mockExtensionConfigurationInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockExtensionConfigurationInstance.get()).thenReturn((Object)deployerConfiguration);
        TestReflectionHelper.setFieldValue(this.instance, "configuration", mockExtensionConfigurationInstance);
        MavenDependencyBuilder mavenDependencyBuilder = new MavenDependencyBuilder();
        mavenDependencyBuilder.addDependency("org.springframework:spring-context", "3.1.1.RELEASE", "3.1.1.RELEASE", new String[0]);
        mavenDependencyBuilder.addDependency("org.springframework:spring-web", "3.1.1.RELEASE", "3.1.1.RELEASE", new String[0]);
        mavenDependencyBuilder.addDependency("cglib:cglib", "2.2.2", "2.2.2", new String[0]);
        File[] dependencies = mavenDependencyBuilder.getDependencies();
        AbstractDependencyResolver abstractDependencyResolver = (AbstractDependencyResolver)Mockito.mock(AbstractDependencyResolver.class);
        Mockito.when((Object)abstractDependencyResolver.resolveDependencies()).thenReturn((Object)dependencies);
        Instance mockDependencyResolverInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockDependencyResolverInstance.get()).thenReturn((Object)abstractDependencyResolver);
        TestReflectionHelper.setFieldValue(this.instance, "dependencyResolver", mockDependencyResolverInstance);
    }

    private void assertDependencies(WebArchive archive, boolean required) {
        boolean isSpringPresent = false;
        boolean isSpringWebPresent = false;
        boolean isCglibPresent = false;
        Map contentMap = archive.getContent((Filter)new Filter<ArchivePath>(){

            public boolean include(ArchivePath object) {
                return object.get().startsWith("/WEB-INF/lib");
            }
        });
        for (ArchivePath key : contentMap.keySet()) {
            if (key.get().contains("/spring-context")) {
                isSpringPresent = true;
                continue;
            }
            if (key.get().contains("/spring-web")) {
                isSpringWebPresent = true;
                continue;
            }
            if (!key.get().contains("/cglib")) continue;
            isCglibPresent = true;
        }
        if (required) {
            Assert.assertTrue((String)"Required dependencies is missing: spring-context.", (boolean)isSpringPresent);
            Assert.assertTrue((String)"Required dependencies is missing: spring-web.", (boolean)isSpringWebPresent);
            Assert.assertTrue((String)"Required dependencies is missing: cglib.", (boolean)isCglibPresent);
        } else {
            Assert.assertFalse((String)"Dependencies should not be added: spring-context.", (boolean)isSpringPresent);
            Assert.assertFalse((String)"Dependencies should not be added: spring-web.", (boolean)isSpringWebPresent);
            Assert.assertFalse((String)"Dependencies should not be added: cglib.", (boolean)isCglibPresent);
        }
    }
}

