/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.deployer.dependency;

import java.io.File;
import org.jboss.arquillian.spring.deployer.dependency.MavenDependencyBuilder;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class MavenDependencyBuilderTestCase {
    private MavenDependencyBuilder instance;

    @Before
    public void setUp() {
        this.instance = new MavenDependencyBuilder();
    }

    @Test
    public void testGetDependencies() {
        File[] result = this.instance.getDependencies();
        Assert.assertNotNull((String)"Invalid value was returned.", (Object)result);
        Assert.assertEquals((String)"Incorrect number of dependencies, none was expected.", (long)0L, (long)result.length);
    }

    @Test
    public void testAddDependenciesDefault() {
        this.instance.addDependency("org.springframework:spring-context", null, "3.0.0.RELEASE", new String[0]);
        File[] result = this.instance.getDependencies();
        Assert.assertNotNull((String)"Invalid value was returned.", (Object)result);
        this.assertDependencyExists(result, "spring-context", "2.5.6");
    }

    @Test(expected=ResolutionException.class)
    @Ignore(value="Will not fail when run through Maven")
    public void testAddDependenciesDefaultEmptyString() {
        this.instance.addDependency("org.springframework:spring-context", null, "", new String[0]);
        this.instance.getDependencies();
    }

    @Test
    public void testAddDependencies() {
        this.instance.addDependency("org.springframework:spring-context", "3.1.1.RELEASE", "3.0.0.RELEASE", new String[0]);
        File[] result = this.instance.getDependencies();
        Assert.assertNotNull((String)"Invalid value was returned.", (Object)result);
        this.assertDependencyExists(result, "spring-context", "2.5.6");
    }

    @Test
    public void testAddDependenciesEmptyString() {
        this.instance.addDependency("org.springframework:spring-context", "", "3.0.0.RELEASE", new String[0]);
        File[] result = this.instance.getDependencies();
        Assert.assertNotNull((String)"Invalid value was returned.", (Object)result);
    }

    @Test(expected=ResolutionException.class)
    @Ignore(value="Will not fail when run through Maven")
    public void testAddDependenciesError() {
        this.instance.addDependency("org.springframework:spring-context", "3", "3", new String[0]);
        this.instance.getDependencies();
    }

    private void assertDependencyExists(File[] files, String artifactName, String version) {
        boolean dependencyExists = false;
        String fileName = String.format("%s-%s.jar", artifactName, version);
        for (File file : files) {
            if (!file.getName().equals(fileName)) continue;
            dependencyExists = true;
            break;
        }
        Assert.assertTrue((String)("The required dependency " + fileName + " is missing."), (boolean)dependencyExists);
    }
}

