/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.deployer.client;

import java.io.File;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.spring.deployer.client.SpringDeployerConfigurationProducer;
import org.jboss.arquillian.spring.deployer.configuration.SpringDeployerConfiguration;
import org.jboss.arquillian.spring.deployer.utils.TestReflectionHelper;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class SpringDeployerConfigurationProducerTestCase {
    private SpringDeployerConfigurationProducer instance;

    @Before
    public void setUp() {
        this.instance = new SpringDeployerConfigurationProducer();
    }

    @Test
    public void testInitConfigurationDefault() throws Exception {
        BeforeSuite event = new BeforeSuite();
        ArquillianDescriptor descriptor = (ArquillianDescriptor)Descriptors.create(ArquillianDescriptor.class);
        this.injectDescriptor(descriptor);
        InstanceProducer mockProducer = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "deployerConfiguration", mockProducer);
        this.instance.initConfiguration(event);
        ArgumentCaptor argument = ArgumentCaptor.forClass(SpringDeployerConfiguration.class);
        ((InstanceProducer)Mockito.verify((Object)mockProducer)).set(argument.capture());
        Assert.assertNotNull((String)"The result was null.", (Object)argument.getValue());
        Assert.assertTrue((String)"Invalid autopackage property.", (boolean)((SpringDeployerConfiguration)argument.getValue()).isAutoPackaging());
        Assert.assertTrue((String)"Invalid enableCache property.", (boolean)((SpringDeployerConfiguration)argument.getValue()).isEnableCache());
        Assert.assertFalse((String)"Invalid useMavenOffline property.", (boolean)((SpringDeployerConfiguration)argument.getValue()).isUseMavenOffline());
        Assert.assertFalse((String)"Invalid includeSnowdrop property.", (boolean)((SpringDeployerConfiguration)argument.getValue()).isIncludeSnowdrop());
        Assert.assertNull((String)"Invalid springVersion property.", (Object)((SpringDeployerConfiguration)argument.getValue()).getSpringVersion());
        Assert.assertNull((String)"Invalid cglibVersion property.", (Object)((SpringDeployerConfiguration)argument.getValue()).getCglibVersion());
        Assert.assertNull((String)"Invalid snowdropVersion property.", (Object)((SpringDeployerConfiguration)argument.getValue()).getSnowdropVersion());
    }

    @Test
    public void testInitConfiguration() throws Exception {
        BeforeSuite event = new BeforeSuite();
        ArquillianDescriptor descriptor = (ArquillianDescriptor)Descriptors.importAs(ArquillianDescriptor.class).fromFile(new File("src/test/resources", "arquillian.xml"));
        this.injectDescriptor(descriptor);
        InstanceProducer mockProducer = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "deployerConfiguration", mockProducer);
        this.instance.initConfiguration(event);
        ArgumentCaptor argument = ArgumentCaptor.forClass(SpringDeployerConfiguration.class);
        ((InstanceProducer)Mockito.verify((Object)mockProducer)).set(argument.capture());
        Assert.assertNotNull((String)"The result was null.", (Object)argument.getValue());
        Assert.assertFalse((String)"Invalid autopackage property.", (boolean)((SpringDeployerConfiguration)argument.getValue()).isAutoPackaging());
        Assert.assertFalse((String)"Invalid enableCache property.", (boolean)((SpringDeployerConfiguration)argument.getValue()).isEnableCache());
        Assert.assertTrue((String)"Invalid includeSnowdrop property.", (boolean)((SpringDeployerConfiguration)argument.getValue()).isIncludeSnowdrop());
        Assert.assertTrue((String)"Invalid useMavenOffline property.", (boolean)((SpringDeployerConfiguration)argument.getValue()).isUseMavenOffline());
        Assert.assertEquals((String)"Invalid springVersion property.", (Object)"3.1.1.RELEASE", (Object)((SpringDeployerConfiguration)argument.getValue()).getSpringVersion());
        Assert.assertEquals((String)"Invalid cglibVersion property.", (Object)"2.2.2", (Object)((SpringDeployerConfiguration)argument.getValue()).getCglibVersion());
        Assert.assertEquals((String)"Invalid snowdropVersion property.", (Object)"2.0.3.Final", (Object)((SpringDeployerConfiguration)argument.getValue()).getSnowdropVersion());
    }

    private void injectDescriptor(ArquillianDescriptor descriptor) throws IllegalAccessException, NoSuchFieldException {
        Instance mockDescriptorInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockDescriptorInstance.get()).thenReturn((Object)descriptor);
        TestReflectionHelper.setFieldValue(this.instance, "descriptor", mockDescriptorInstance);
    }
}

