/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.testsuite.test;

import java.io.File;
import org.jboss.arquillian.spring.testsuite.beans.config.AppConfig;
import org.jboss.arquillian.spring.testsuite.beans.config.WebAppConfig;
import org.jboss.arquillian.spring.testsuite.beans.controller.EmployeeController;
import org.jboss.arquillian.spring.testsuite.beans.controller.EmployeeRestController;
import org.jboss.arquillian.spring.testsuite.beans.model.Employee;
import org.jboss.arquillian.spring.testsuite.beans.repository.EmployeeRepository;
import org.jboss.arquillian.spring.testsuite.beans.repository.impl.DefaultEmployeeRepository;
import org.jboss.arquillian.spring.testsuite.beans.repository.impl.JpaEmployeeRepository;
import org.jboss.arquillian.spring.testsuite.beans.repository.impl.NullEmployeeRepository;
import org.jboss.arquillian.spring.testsuite.beans.service.EmployeeService;
import org.jboss.arquillian.spring.testsuite.beans.service.impl.DefaultEmployeeService;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.DependencyResolvers;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;

public final class Deployments {
    private Deployments() {
    }

    public static Archive createRepositoriesDeployment() {
        return Deployments.createAppDeployment().addAsResource("applicationContext.xml");
    }

    public static Archive createServicesDeployment() {
        return Deployments.createAppDeployment().addAsResource("applicationContext.xml");
    }

    public static Archive createJavaConfigDeployment() {
        return Deployments.createAppDeployment().addClasses(new Class[]{AppConfig.class});
    }

    public static WebArchive createWebApplication() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"spring-test.war")).addClasses(new Class[]{Employee.class, EmployeeService.class, DefaultEmployeeService.class, EmployeeRepository.class, DefaultEmployeeRepository.class, NullEmployeeRepository.class, EmployeeController.class, EmployeeRestController.class})).addAsLibraries(Deployments.getWebDependencies());
    }

    public static WebArchive createWeb3Application() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"spring-test.war")).addClasses(new Class[]{Employee.class, EmployeeService.class, DefaultEmployeeService.class, EmployeeRepository.class, DefaultEmployeeRepository.class, NullEmployeeRepository.class, EmployeeController.class, EmployeeRestController.class, WebAppConfig.class})).addAsLibraries(Deployments.getWebDependencies());
    }

    public static Archive createJpaDeployment() {
        return ((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)Deployments.createAppDeployment().addClasses(new Class[]{JpaEmployeeRepository.class})).addAsWebInfResource("jbossas-ds.xml")).addAsWebInfResource("web.xml")).addAsResource("applicationContext-jpa.xml")).addAsResource("persistence/persistence.xml", "META-INF/persistence.xml")).addAsResource("persistence/insert.sql", "insert.sql");
    }

    public static WebArchive createAppDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"spring-test.war")).addClasses(new Class[]{Employee.class, EmployeeService.class, DefaultEmployeeService.class, EmployeeRepository.class, DefaultEmployeeRepository.class, NullEmployeeRepository.class})).addAsLibraries(Deployments.getDependencies());
    }

    public static File[] getDependencies() {
        return Deployments.resolveArtifact("org.springframework:spring-tx", "org.springframework:spring-tx", "org.springframework:spring-orm", "org.mockito:mockito-all");
    }

    public static File[] getWebDependencies() {
        return Deployments.resolveArtifact("org.springframework:spring-webmvc", "org.codehaus.jackson:jackson-mapper-asl", "org.springframework:spring-tx", "org.springframework:spring-orm", "org.mockito:mockito-all");
    }

    public static File[] resolveArtifact(String ... artifacts) {
        MavenDependencyResolver mvnResolver = (MavenDependencyResolver)DependencyResolvers.use(MavenDependencyResolver.class);
        mvnResolver.loadMetadataFromPom("pom.xml");
        return ((MavenDependencyResolver)mvnResolver.artifacts(artifacts)).resolveAsFiles();
    }
}

