/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.testsuite.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.spring.integration.test.annotation.SpringConfiguration;
import org.jboss.arquillian.spring.testsuite.beans.model.Employee;
import org.jboss.arquillian.spring.testsuite.beans.repository.EmployeeRepository;
import org.jboss.arquillian.spring.testsuite.test.Deployments;
import org.jboss.arquillian.transaction.api.annotation.Transactional;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@RunWith(value=Arquillian.class)
@Transactional(manager="txManager")
@SpringConfiguration(value={"applicationContext-jpa.xml"})
public class JpaEmployeeRepositoryTestCase {
    @Autowired
    @Qualifier(value="jpaEmployeeRepository")
    private EmployeeRepository employeeRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Deployment
    public static Archive createTestArchive() {
        return Deployments.createJpaDeployment();
    }

    @After
    public void tearDown() {
        this.entityManager.createNativeQuery("delete from Employee").executeUpdate();
    }

    @Test
    public void testSave() {
        Employee employee = new Employee();
        employee.setName("Test employee");
        this.employeeRepository.save(employee);
        employee = new Employee();
        employee.setName("New employee");
        this.employeeRepository.save(employee);
        List result = this.entityManager.createQuery("from Employee").getResultList();
        Assert.assertNotNull((String)"Method returned null list as result.", (Object)result);
        Assert.assertEquals((String)"Two employees were expected.", (long)2L, (long)result.size());
    }

    @Test
    public void testGetEmployees() throws Exception {
        JpaEmployeeRepositoryTestCase.runScript(this.entityManager, "insert.sql");
        List<Employee> result = this.employeeRepository.getEmployees();
        Assert.assertNotNull((String)"Method returned null list as result.", result);
        Assert.assertEquals((String)"Two employees were expected.", (long)2L, (long)result.size());
    }

    public static void runScript(EntityManager entityManager, String fileName) throws IOException {
        String[] commands;
        String line;
        InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(input));
        StringBuilder stringBuilder = new StringBuilder();
        while ((line = inputReader.readLine()) != null) {
            if (line.startsWith("--")) continue;
            stringBuilder.append(line);
        }
        for (String command : commands = stringBuilder.toString().split(";")) {
            entityManager.createNativeQuery(command).executeUpdate();
        }
    }
}

