/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.inject.container;

import java.util.Collections;
import java.util.HashMap;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.spring.integration.configuration.SpringIntegrationConfiguration;
import org.jboss.arquillian.spring.integration.context.TestScopeApplicationContext;
import org.jboss.arquillian.spring.integration.inject.container.XmlApplicationContextProducer;
import org.jboss.arquillian.spring.integration.inject.model.PlainClass;
import org.jboss.arquillian.spring.integration.inject.model.XmlAnnotatedClass;
import org.jboss.arquillian.spring.integration.inject.model.XmlAnnotatedCustomContextClass;
import org.jboss.arquillian.spring.integration.inject.model.XmlAnnotatedMissingResourceClass;
import org.jboss.arquillian.spring.integration.inject.utils.TestReflectionHelper;
import org.jboss.arquillian.test.spi.TestClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class XmlApplicationContextProducerTestCase {
    private XmlApplicationContextProducer instance;
    private SpringIntegrationConfiguration remoteConfiguration;

    @Before
    public void setUp() throws Exception {
        this.instance = new XmlApplicationContextProducer();
        this.remoteConfiguration = new SpringIntegrationConfiguration(Collections.emptyMap());
        this.setRemoteConfiguration();
    }

    @Test
    public void testSupportsFalse() {
        TestClass testClass = new TestClass(PlainClass.class);
        Assert.assertFalse((String)"Class without annotations shouldn't be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testSupportsTrue() {
        TestClass testClass = new TestClass(XmlAnnotatedClass.class);
        Assert.assertTrue((String)"Class should be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testCreateApplicationContextDefault() {
        TestClass testClass = new TestClass(XmlAnnotatedClass.class);
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test
    public void testCreateApplicationContextCustomContextConfiguration() throws Exception {
        TestClass testClass = new TestClass(XmlAnnotatedClass.class);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("customContextClass", "org.springframework.context.support.ClassPathXmlApplicationContext");
        this.remoteConfiguration = new SpringIntegrationConfiguration(properties);
        this.setRemoteConfiguration();
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextCustomContextConfigurationError() throws Exception {
        TestClass testClass = new TestClass(XmlAnnotatedClass.class);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("customContextClass", "invalid class name");
        this.remoteConfiguration = new SpringIntegrationConfiguration(properties);
        this.setRemoteConfiguration();
        this.instance.createApplicationContext(testClass);
    }

    @Test
    public void testCreateApplicationContextCustomContext() {
        TestClass testClass = new TestClass(XmlAnnotatedCustomContextClass.class);
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextCustomContextConfigurationAndAnnotation() throws Exception {
        TestClass testClass = new TestClass(XmlAnnotatedCustomContextClass.class);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("customContextClass", "invalid class name");
        this.remoteConfiguration = new SpringIntegrationConfiguration(properties);
        this.setRemoteConfiguration();
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextMissingResource() {
        TestClass testClass = new TestClass(XmlAnnotatedMissingResourceClass.class);
        this.instance.createApplicationContext(testClass);
    }

    private void setRemoteConfiguration() throws Exception {
        Instance mockRemoteConfigurationInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockRemoteConfigurationInstance.get()).thenReturn((Object)this.remoteConfiguration);
        TestReflectionHelper.setFieldValue(this.instance, "remoteConfiguration", mockRemoteConfigurationInstance);
    }
}

