/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.inject.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jboss.arquillian.spring.integration.container.SecurityActions;
import org.jboss.arquillian.spring.integration.context.AbstractApplicationContextProducer;
import org.jboss.arquillian.spring.integration.context.TestScopeApplicationContext;
import org.jboss.arquillian.spring.integration.test.annotation.SpringConfiguration;
import org.jboss.arquillian.test.spi.TestClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlApplicationContextProducer
extends AbstractApplicationContextProducer {
    public boolean supports(TestClass testClass) {
        return testClass.isAnnotationPresent(SpringConfiguration.class);
    }

    public TestScopeApplicationContext createApplicationContext(TestClass testClass) {
        return new TestScopeApplicationContext(this.getApplicationContext(testClass), true);
    }

    private ApplicationContext getApplicationContext(TestClass testClass) {
        SpringConfiguration springConfiguration = (SpringConfiguration)testClass.getAnnotation(SpringConfiguration.class);
        String[] locations = new String[]{"classpath:applicationContext.xml"};
        if (springConfiguration.value().length > 0) {
            locations = springConfiguration.value();
        }
        Class<? extends ApplicationContext> applicationContextClass = this.getCustomContextClass();
        if (springConfiguration.contextClass() != ApplicationContext.class) {
            applicationContextClass = springConfiguration.contextClass();
        }
        if (applicationContextClass == null) {
            applicationContextClass = ClassPathXmlApplicationContext.class;
        }
        return this.createInstance(applicationContextClass, locations);
    }

    private Class<? extends ApplicationContext> getCustomContextClass() {
        String customContextClass = this.getRemoteConfiguration().getProperty("customContextClass");
        if (customContextClass != null && customContextClass.trim().length() > 0) {
            return SecurityActions.classForName((String)customContextClass);
        }
        return null;
    }

    private <T extends ApplicationContext> ApplicationContext createInstance(Class<T> applicationContextClass, String[] locations) {
        try {
            Constructor<T> ctor = applicationContextClass.getConstructor(String[].class);
            return (ApplicationContext)ctor.newInstance(new Object[]{locations});
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not create instance of " + applicationContextClass.getName() + ", no appropriate constructor found.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Could not create instance of " + applicationContextClass.getName(), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not create instance of " + applicationContextClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not create instance of " + applicationContextClass.getName(), e);
        }
    }
}

