/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.inject.container;

import java.util.Collections;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.spring.integration.configuration.SpringIntegrationConfiguration;
import org.jboss.arquillian.spring.integration.context.RemoteTestScopeApplicationContext;
import org.jboss.arquillian.spring.integration.inject.container.CustomRemoteApplicationContextProducer;
import org.jboss.arquillian.spring.integration.inject.model.CustomApplicationContextClass;
import org.jboss.arquillian.spring.integration.inject.model.CustomExceptionApplicationContextClass;
import org.jboss.arquillian.spring.integration.inject.model.CustomInvalidApplicationContextClass;
import org.jboss.arquillian.spring.integration.inject.model.CustomNullApplicationContextClass;
import org.jboss.arquillian.spring.integration.inject.model.PlainClass;
import org.jboss.arquillian.spring.integration.inject.test.TestReflectionHelper;
import org.jboss.arquillian.test.spi.TestClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class CustomRemoteApplicationContextProducerTestCase {
    private CustomRemoteApplicationContextProducer instance;
    private SpringIntegrationConfiguration remoteConfiguration;

    @Before
    public void setUp() throws Exception {
        this.instance = new CustomRemoteApplicationContextProducer();
        this.remoteConfiguration = new SpringIntegrationConfiguration(Collections.emptyMap());
        this.setRemoteConfiguration();
    }

    @Test
    public void testSupportsFalse() {
        TestClass testClass = new TestClass(PlainClass.class);
        Assert.assertFalse((String)"Class without annotations shouldn't be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testSupportsTrue() {
        TestClass testClass = new TestClass(CustomApplicationContextClass.class);
        Assert.assertTrue((String)"Class should be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testCreateApplicationContextDefault() {
        TestClass testClass = new TestClass(CustomApplicationContextClass.class);
        RemoteTestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextNull() throws Exception {
        TestClass testClass = new TestClass(CustomNullApplicationContextClass.class);
        this.instance.createApplicationContext(testClass);
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextMultipleMethods() throws Exception {
        TestClass testClass = new TestClass(CustomNullApplicationContextClass.class);
        this.instance.createApplicationContext(testClass);
    }

    @Test(expected=ClassCastException.class)
    public void testCreateApplicationContextIncorrectMethodContract() throws Exception {
        TestClass testClass = new TestClass(CustomInvalidApplicationContextClass.class);
        this.instance.createApplicationContext(testClass);
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextErrorPropagation() throws Exception {
        TestClass testClass = new TestClass(CustomExceptionApplicationContextClass.class);
        this.instance.createApplicationContext(testClass);
    }

    private void setRemoteConfiguration() throws Exception {
        Instance mockRemoteConfigurationInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockRemoteConfigurationInstance.get()).thenReturn((Object)this.remoteConfiguration);
        TestReflectionHelper.setFieldValue(this.instance, "remoteConfiguration", mockRemoteConfigurationInstance);
    }
}

