/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.inject.container;

import java.util.Collections;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.spring.integration.configuration.SpringIntegrationConfiguration;
import org.jboss.arquillian.spring.integration.inject.container.WebApplicationContextProducer;
import org.jboss.arquillian.spring.integration.inject.model.PlainClass;
import org.jboss.arquillian.spring.integration.inject.model.WebAnnotatedClass;
import org.jboss.arquillian.spring.integration.inject.test.TestReflectionHelper;
import org.jboss.arquillian.test.spi.TestClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class WebApplicationContextProducerTestCase {
    private WebApplicationContextProducer instance;

    @Before
    public void setUp() throws Exception {
        this.instance = new WebApplicationContextProducer();
        SpringIntegrationConfiguration extensionRemoteConfiguration = new SpringIntegrationConfiguration(Collections.emptyMap());
        Instance mockExtensionRemoteConfigurationInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockExtensionRemoteConfigurationInstance.get()).thenReturn((Object)extensionRemoteConfiguration);
        TestReflectionHelper.setFieldValue(this.instance, "remoteConfiguration", mockExtensionRemoteConfigurationInstance);
    }

    @Test
    public void testSupportsFalse() {
        TestClass testClass = new TestClass(PlainClass.class);
        Assert.assertFalse((String)"Class without annotations shouldn't be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testSupportsTrue() {
        TestClass testClass = new TestClass(WebAnnotatedClass.class);
        Assert.assertTrue((String)"Class should be supported.", (boolean)this.instance.supports(testClass));
    }
}

