/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.inject.client;

import org.jboss.arquillian.spring.integration.context.ClientApplicationContextProducer;
import org.jboss.arquillian.spring.integration.context.ClientTestScopeApplicationContext;
import org.jboss.arquillian.spring.integration.inject.utils.ClassPathResourceLocationsProcessor;
import org.jboss.arquillian.spring.integration.test.annotation.SpringClientConfiguration;
import org.jboss.arquillian.test.spi.TestClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class XmlClientApplicationContextProducer
implements ClientApplicationContextProducer {
    private final ClassPathResourceLocationsProcessor locationsProcessor = new ClassPathResourceLocationsProcessor();

    public boolean supports(TestClass testClass) {
        return testClass.isAnnotationPresent(SpringClientConfiguration.class);
    }

    public ClientTestScopeApplicationContext createApplicationContext(TestClass testClass) {
        return new ClientTestScopeApplicationContext(this.getApplicationContext(testClass), testClass, true);
    }

    private ApplicationContext getApplicationContext(TestClass testClass) {
        SpringClientConfiguration springConfiguration = (SpringClientConfiguration)testClass.getAnnotation(SpringClientConfiguration.class);
        String[] locations = this.locationsProcessor.processLocations(springConfiguration.value(), testClass.getJavaClass());
        return new ClassPathXmlApplicationContext(locations);
    }
}

