/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.inject.utils;

import org.springframework.core.io.ClassPathResource;

public class ClassPathResourceLocationsProcessor {
    static final String DEFAULT_LOCATION_SUFFIX = "-context.xml";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String SLASH = "/";

    public String[] processLocations(String[] configurationLocations, Class wrappedClass) {
        if (this.customLocationsWereSpecified(configurationLocations)) {
            return configurationLocations;
        }
        return this.defaultLocationForGivenTestClass(wrappedClass);
    }

    private boolean customLocationsWereSpecified(String[] locations) {
        return locations.length > 0;
    }

    String[] defaultLocationForGivenTestClass(Class testClass) {
        String fullyQualifiedTestClassName = testClass.getName();
        String defaultConfigResourcePath = SLASH + fullyQualifiedTestClassName.replace('.', '/') + DEFAULT_LOCATION_SUFFIX;
        String prefixedResourcePath = CLASSPATH_PREFIX + defaultConfigResourcePath;
        ClassPathResource classPathResource = new ClassPathResource(defaultConfigResourcePath, testClass);
        if (classPathResource.exists()) {
            return new String[]{prefixedResourcePath};
        }
        return EMPTY_STRING_ARRAY;
    }
}

