/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.inject.client;

import org.fest.assertions.Assertions;
import org.jboss.arquillian.spring.integration.configuration.SpringIntegrationConfiguration;
import org.jboss.arquillian.spring.integration.context.ClientTestScopeApplicationContext;
import org.jboss.arquillian.spring.integration.inject.client.XmlClientApplicationContextProducer;
import org.jboss.arquillian.spring.integration.inject.model.ClientXmlAnnotatedClass;
import org.jboss.arquillian.spring.integration.inject.model.ClientXmlAnnotatedClassWithBothCustomAndDefaultLocations;
import org.jboss.arquillian.spring.integration.inject.model.PlainClass;
import org.jboss.arquillian.spring.integration.inject.model.XmlAnnotatedMissingResourceClass;
import org.jboss.arquillian.test.spi.TestClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XmlClientApplicationContextProducerTestCase {
    private XmlClientApplicationContextProducer instance;
    private SpringIntegrationConfiguration remoteConfiguration;

    @Before
    public void setUp() throws Exception {
        this.instance = new XmlClientApplicationContextProducer();
    }

    @Test
    public void testSupportsFalse() {
        TestClass testClass = new TestClass(PlainClass.class);
        Assert.assertFalse((String)"Class without annotations shouldn't be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testSupportsTrue() {
        TestClass testClass = new TestClass(ClientXmlAnnotatedClass.class);
        Assert.assertTrue((String)"Class should be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testCreateApplicationContextDefault() {
        TestClass testClass = new TestClass(ClientXmlAnnotatedClass.class);
        ClientTestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextMissingResource() {
        TestClass testClass = new TestClass(XmlAnnotatedMissingResourceClass.class);
        this.instance.createApplicationContext(testClass);
    }

    @Test
    public void customContextShouldBeChosenWhenBothDefaultAndCustomResourcesExist() {
        TestClass testClass = new TestClass(ClientXmlAnnotatedClassWithBothCustomAndDefaultLocations.class);
        ClientTestScopeApplicationContext applicationContext = this.instance.createApplicationContext(testClass);
        Assertions.assertThat((Object[])applicationContext.getApplicationContext().getBeanDefinitionNames()).isEmpty();
        Assertions.assertThat((int)applicationContext.getApplicationContext().getBeanDefinitionCount()).isEqualTo(0);
    }

    @Test
    public void createdApplicationContextCreatedFromDefaultResourceShouldContainSingleBean() {
        TestClass testClass = new TestClass(ClientXmlAnnotatedClass.class);
        ClientTestScopeApplicationContext applicationContext = this.instance.createApplicationContext(testClass);
        Assertions.assertThat((Object[])applicationContext.getApplicationContext().getBeanDefinitionNames()).isNotEmpty();
        Assertions.assertThat((int)applicationContext.getApplicationContext().getBeanDefinitionCount()).isEqualTo(1);
        Assertions.assertThat((String)applicationContext.getApplicationContext().getBeanDefinitionNames()[0]).contains(PlainClass.class.getName());
    }
}

