/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.inject.utils;

import org.fest.assertions.Assertions;
import org.jboss.arquillian.spring.integration.inject.model.ClientXmlAnnotatedClass;
import org.jboss.arquillian.spring.integration.inject.model.ClientXmlAnnotatedClassWithBothCustomAndDefaultLocations;
import org.jboss.arquillian.spring.integration.inject.model.ClientXmlAnnotatedClassWithNotExistingDefaultLocation;
import org.jboss.arquillian.spring.integration.inject.utils.ClassPathResourceLocationsProcessor;
import org.jboss.arquillian.spring.integration.test.annotation.SpringClientConfiguration;
import org.junit.Test;

public class ClassPathResourceLocationsProcessorTestCase {
    private ClassPathResourceLocationsProcessor locationsProcessor = new ClassPathResourceLocationsProcessor();

    @Test
    public void emptyArrayShouldBeReturnedWhenDefaultTestResourceDoesNotExist() {
        Class<ClientXmlAnnotatedClassWithNotExistingDefaultLocation> testClass = ClientXmlAnnotatedClassWithNotExistingDefaultLocation.class;
        Object[] defaultLocations = this.locationsProcessor.defaultLocationForGivenTestClass(testClass);
        Assertions.assertThat((Object[])defaultLocations).isEmpty();
    }

    @Test
    public void arrayWithDefaultLocationShouldBeReturnedWhenDefaultResourceExists() {
        Class<ClientXmlAnnotatedClass> testClass = ClientXmlAnnotatedClass.class;
        String expectedLocationName = testClass.getClass().getSimpleName() + "-context.xml";
        Object[] defaultLocations = this.locationsProcessor.defaultLocationForGivenTestClass(testClass);
        Assertions.assertThat((Object[])defaultLocations).hasSize(1);
        Assertions.assertThat((String)defaultLocations[0]).contains(expectedLocationName);
    }

    @Test
    public void arrayWithCustomLocationShouldBeReturnedWhenBothDefaultAndCustomResourcesExist() {
        Class<ClientXmlAnnotatedClassWithBothCustomAndDefaultLocations> wrappedClass = ClientXmlAnnotatedClassWithBothCustomAndDefaultLocations.class;
        SpringClientConfiguration testClassAnnotation = wrappedClass.getAnnotation(SpringClientConfiguration.class);
        String[] expectedLocationNames = testClassAnnotation.value();
        Object[] defaultLocations = this.locationsProcessor.processLocations(testClassAnnotation.value(), wrappedClass);
        Assertions.assertThat((Object[])defaultLocations).hasSize(expectedLocationNames.length);
        Assertions.assertThat((Object[])defaultLocations).containsOnly((Object[])expectedLocationNames);
    }
}

