/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.javaconfig.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.spring.integration.configuration.SpringIntegrationConfiguration;
import org.jboss.arquillian.spring.integration.javaconfig.client.SpringJavaConfigArchiveAppender;
import org.jboss.arquillian.spring.integration.javaconfig.container.AnnotationApplicationContextProducer;
import org.jboss.arquillian.spring.integration.javaconfig.container.SpringJavaConfigRemoteExtension;
import org.jboss.arquillian.spring.integration.javaconfig.utils.TestReflectionHelper;
import org.jboss.arquillian.spring.integration.javaconfig.utils.TestResourceHelper;
import org.jboss.arquillian.spring.integration.test.annotation.SpringAnnotationConfiguration;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SpringJavaConfigArchiveAppenderTestCase {
    private SpringJavaConfigArchiveAppender instance;
    private static final List<Class<?>> REQUIRED_CLASSES = Arrays.asList(SpringAnnotationConfiguration.class, AnnotationApplicationContextProducer.class, SpringJavaConfigRemoteExtension.class);

    @Before
    public void setUp() {
        this.instance = new SpringJavaConfigArchiveAppender();
    }

    @Test
    public void testCreateAuxiliaryArchive() throws Exception {
        SpringIntegrationConfiguration configuration = new SpringIntegrationConfiguration(Collections.emptyMap());
        Instance mockConfigurationInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockConfigurationInstance.get()).thenReturn((Object)configuration);
        TestReflectionHelper.setFieldValue(this.instance, "configuration", mockConfigurationInstance);
        Archive archive = this.instance.createAuxiliaryArchive();
        Assert.assertNotNull((String)"Method returned null.", (Object)archive);
        Assert.assertTrue((String)"The returned archive has incorrect type.", (boolean)(archive instanceof JavaArchive));
        for (Class<?> c : REQUIRED_CLASSES) {
            Assert.assertTrue((String)("The required type is missing: " + c.getName()), (boolean)archive.contains(TestResourceHelper.getClassResourcePath(c)));
        }
    }
}

