/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.javaconfig.container;

import java.util.Collections;
import java.util.HashMap;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.spring.integration.configuration.SpringIntegrationConfiguration;
import org.jboss.arquillian.spring.integration.context.TestScopeApplicationContext;
import org.jboss.arquillian.spring.integration.javaconfig.container.AnnotationApplicationContextProducer;
import org.jboss.arquillian.spring.integration.javaconfig.model.AnnotatedClassesCustomContextClass;
import org.jboss.arquillian.spring.integration.javaconfig.model.AnnotatedPackagesCustomContextClass;
import org.jboss.arquillian.spring.integration.javaconfig.model.ClassesAnnotatedClass;
import org.jboss.arquillian.spring.integration.javaconfig.model.NoConfigAnnotatedClass;
import org.jboss.arquillian.spring.integration.javaconfig.model.PackagesAnnotatedClass;
import org.jboss.arquillian.spring.integration.javaconfig.model.PlainClass;
import org.jboss.arquillian.spring.integration.javaconfig.utils.TestReflectionHelper;
import org.jboss.arquillian.test.spi.TestClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class AnnotationApplicationContextProducerTestCase {
    private AnnotationApplicationContextProducer instance;
    private SpringIntegrationConfiguration remoteConfiguration;

    @Before
    public void setUp() throws Exception {
        this.instance = new AnnotationApplicationContextProducer();
        this.remoteConfiguration = new SpringIntegrationConfiguration(Collections.emptyMap());
        this.setUpRemoteConfiguration();
    }

    @Test
    public void testSupportsFalse() {
        TestClass testClass = new TestClass(PlainClass.class);
        Assert.assertFalse((String)"Class without annotations shouldn't be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testSupportsTrue1() {
        TestClass testClass = new TestClass(ClassesAnnotatedClass.class);
        Assert.assertTrue((String)"Class should be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testSupportsTrue2() {
        TestClass testClass = new TestClass(PackagesAnnotatedClass.class);
        Assert.assertTrue((String)"Class should be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testCreateApplicationContextCustomContextClassesConfiguration() throws Exception {
        TestClass testClass = new TestClass(ClassesAnnotatedClass.class);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("customAnnotationContextClass", "org.springframework.context.annotation.AnnotationConfigApplicationContext");
        this.remoteConfiguration = new SpringIntegrationConfiguration(properties);
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextCustomContextClassesConfigurationError() throws Exception {
        TestClass testClass = new TestClass(ClassesAnnotatedClass.class);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("customAnnotationContextClass", "invalid class name");
        this.remoteConfiguration = new SpringIntegrationConfiguration(properties);
        this.setUpRemoteConfiguration();
        this.instance.createApplicationContext(testClass);
    }

    @Test
    public void testCreateApplicationContextCustomContextPackagesConfiguration() throws Exception {
        TestClass testClass = new TestClass(PackagesAnnotatedClass.class);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("customAnnotationContextClass", "org.springframework.context.annotation.AnnotationConfigApplicationContext");
        this.remoteConfiguration = new SpringIntegrationConfiguration(properties);
        this.setUpRemoteConfiguration();
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextCustomContextPackagesConfigurationError() throws Exception {
        TestClass testClass = new TestClass(PackagesAnnotatedClass.class);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("customAnnotationContextClass", "invalid class name");
        this.remoteConfiguration = new SpringIntegrationConfiguration(properties);
        this.setUpRemoteConfiguration();
        this.instance.createApplicationContext(testClass);
    }

    @Test
    public void testCreateApplicationContextCustomContextClasses() {
        TestClass testClass = new TestClass(AnnotatedClassesCustomContextClass.class);
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextCustomContextClassesConfigurationAndAnnotation() throws Exception {
        TestClass testClass = new TestClass(AnnotatedClassesCustomContextClass.class);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("customAnnotationContextClass", "invalid class name");
        this.remoteConfiguration = new SpringIntegrationConfiguration(properties);
        this.setUpRemoteConfiguration();
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test
    public void testCreateApplicationContextCustomContextPackages() {
        TestClass testClass = new TestClass(AnnotatedPackagesCustomContextClass.class);
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextCustomContextPackagesConfigurationAndAnnotation() throws Exception {
        TestClass testClass = new TestClass(AnnotatedPackagesCustomContextClass.class);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("customAnnotationContextClass", "invalid class name");
        this.remoteConfiguration = new SpringIntegrationConfiguration(properties);
        this.setUpRemoteConfiguration();
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextError() {
        TestClass testClass = new TestClass(NoConfigAnnotatedClass.class);
        this.instance.createApplicationContext(testClass);
    }

    private void setUpRemoteConfiguration() throws Exception {
        Instance mockRemoteConfigurationInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockRemoteConfigurationInstance.get()).thenReturn((Object)this.remoteConfiguration);
        TestReflectionHelper.setFieldValue(this.instance, "remoteConfiguration", mockRemoteConfigurationInstance);
    }
}

