/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.javaconfig.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jboss.arquillian.spring.integration.container.SecurityActions;
import org.jboss.arquillian.spring.integration.context.AbstractApplicationContextProducer;
import org.jboss.arquillian.spring.integration.context.TestScopeApplicationContext;
import org.jboss.arquillian.spring.integration.test.annotation.SpringAnnotationConfiguration;
import org.jboss.arquillian.test.spi.TestClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationApplicationContextProducer
extends AbstractApplicationContextProducer {
    public boolean supports(TestClass testClass) {
        return testClass.isAnnotationPresent(SpringAnnotationConfiguration.class);
    }

    public TestScopeApplicationContext createApplicationContext(TestClass testClass) {
        return new TestScopeApplicationContext(this.getApplicationContext(testClass), true);
    }

    private ApplicationContext getApplicationContext(TestClass testClass) {
        SpringAnnotationConfiguration springConfiguration = (SpringAnnotationConfiguration)testClass.getAnnotation(SpringAnnotationConfiguration.class);
        String[] packages = springConfiguration.packages();
        Class<?>[] classes = springConfiguration.classes();
        Class<? extends ApplicationContext> customAnnotationContextClass = this.getCustomAnnotationContextClass();
        if (springConfiguration.contextClass() != ApplicationContext.class) {
            customAnnotationContextClass = springConfiguration.contextClass();
        }
        if (customAnnotationContextClass != null) {
            return this.createCustomAnnotatedApplicationContext(testClass, customAnnotationContextClass, classes, packages);
        }
        return this.createAnnotatedApplicationContext(testClass, packages, classes);
    }

    private Class<? extends ApplicationContext> getCustomAnnotationContextClass() {
        String customAnnotationContextClass = this.getRemoteConfiguration().getProperty("customAnnotationContextClass");
        if (customAnnotationContextClass != null && customAnnotationContextClass.trim().length() > 0) {
            return SecurityActions.classForName((String)customAnnotationContextClass);
        }
        return null;
    }

    private ApplicationContext createAnnotatedApplicationContext(TestClass testClass, String[] packages, Class<?>[] classes) {
        if (packages.length > 0 || classes.length > 0) {
            return this.createAnnotatedApplicationContext(classes, packages);
        }
        throw new RuntimeException("The test: " + testClass.getName() + " annotated with SpringAnnotationConfiguration must specify the configuration classes or packages.");
    }

    private ApplicationContext createAnnotatedApplicationContext(Class<?>[] classes, String[] packages) {
        if (classes.length > 0) {
            AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext((Class[])classes);
            if (packages.length > 0) {
                applicationContext.scan(packages);
                applicationContext.refresh();
            }
            return applicationContext;
        }
        return new AnnotationConfigApplicationContext(packages);
    }

    private <T extends ApplicationContext> T createCustomAnnotatedApplicationContext(TestClass testClass, Class<T> applicationContextClass, Class<?>[] classes, String[] packages) {
        if (classes.length > 0 && packages.length > 0) {
            Constructor<T> ctor = this.getConstructor(applicationContextClass, Class[].class, String[].class);
            return this.createInstance(applicationContextClass, ctor, classes, packages);
        }
        if (classes.length > 0) {
            Constructor<T> ctor = this.getConstructor(applicationContextClass, Class[].class);
            return this.createInstance(applicationContextClass, ctor, new Object[]{classes});
        }
        if (packages.length > 0) {
            Constructor<T> ctor = this.getConstructor(applicationContextClass, String[].class);
            return this.createInstance(applicationContextClass, ctor, new Object[]{packages});
        }
        throw new RuntimeException("The test: " + testClass.getName() + " annotated with SpringAnnotationConfiguration must specify the configuration classes or packages.");
    }

    private <T extends ApplicationContext> T createInstance(Class<T> applicationContextClass, Constructor<T> ctor, Object ... params) {
        try {
            return (T)((ApplicationContext)ctor.newInstance(params));
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not create instance of " + applicationContextClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not create instance of " + applicationContextClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Could not create instance of " + applicationContextClass.getName(), e);
        }
    }

    private <T extends ApplicationContext> Constructor<T> getConstructor(Class<T> type, Class ... parameterTypes) {
        try {
            return type.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find a proper constructor for type: " + type.getName(), e);
        }
    }
}

