/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.javaconfig.client;

import org.jboss.arquillian.spring.integration.context.ClientTestScopeApplicationContext;
import org.jboss.arquillian.spring.integration.javaconfig.client.AnnotationClientApplicationContextProducer;
import org.jboss.arquillian.spring.integration.javaconfig.model.ClientClassesAnnotatedClass;
import org.jboss.arquillian.spring.integration.javaconfig.model.ClientPackagesAnnotatedClass;
import org.jboss.arquillian.spring.integration.javaconfig.model.NoConfigAnnotatedClass;
import org.jboss.arquillian.spring.integration.javaconfig.model.PlainClass;
import org.jboss.arquillian.test.spi.TestClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AnnotationClientApplicationContextProducerTestCase {
    private AnnotationClientApplicationContextProducer instance;

    @Before
    public void setUp() throws Exception {
        this.instance = new AnnotationClientApplicationContextProducer();
    }

    @Test
    public void testSupportsFalse() {
        TestClass testClass = new TestClass(PlainClass.class);
        Assert.assertFalse((String)"Class without annotations shouldn't be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testSupportsTrue1() {
        TestClass testClass = new TestClass(ClientClassesAnnotatedClass.class);
        Assert.assertTrue((String)"Class should be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testSupportsTrue2() {
        TestClass testClass = new TestClass(ClientPackagesAnnotatedClass.class);
        Assert.assertTrue((String)"Class should be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testCreateApplicationContextClasses() throws Exception {
        TestClass testClass = new TestClass(ClientClassesAnnotatedClass.class);
        ClientTestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test
    public void testCreateApplicationContextPackages() throws Exception {
        TestClass testClass = new TestClass(ClientClassesAnnotatedClass.class);
        ClientTestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextError() {
        TestClass testClass = new TestClass(NoConfigAnnotatedClass.class);
        this.instance.createApplicationContext(testClass);
    }
}

