/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.javaconfig.client;

import org.jboss.arquillian.spring.integration.context.ClientApplicationContextProducer;
import org.jboss.arquillian.spring.integration.context.ClientTestScopeApplicationContext;
import org.jboss.arquillian.spring.integration.test.annotation.SpringClientAnnotationConfiguration;
import org.jboss.arquillian.test.spi.TestClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationClientApplicationContextProducer
implements ClientApplicationContextProducer {
    public boolean supports(TestClass testClass) {
        return testClass.isAnnotationPresent(SpringClientAnnotationConfiguration.class);
    }

    public ClientTestScopeApplicationContext createApplicationContext(TestClass testClass) {
        return new ClientTestScopeApplicationContext(this.getApplicationContext(testClass), true);
    }

    private ApplicationContext getApplicationContext(TestClass testClass) {
        SpringClientAnnotationConfiguration springConfiguration = (SpringClientAnnotationConfiguration)testClass.getAnnotation(SpringClientAnnotationConfiguration.class);
        String[] packages = springConfiguration.packages();
        Class<?>[] classes = springConfiguration.classes();
        return this.createAnnotatedApplicationContext(testClass, packages, classes);
    }

    private ApplicationContext createAnnotatedApplicationContext(TestClass testClass, String[] packages, Class<?>[] classes) {
        if (packages.length > 0 || classes.length > 0) {
            return this.createAnnotatedApplicationContext(classes, packages);
        }
        throw new RuntimeException("The test: " + testClass.getName() + " annotated with SpringClientAnnotationConfiguration must specify the configuration" + " classes or packages.");
    }

    private ApplicationContext createAnnotatedApplicationContext(Class<?>[] classes, String[] packages) {
        if (classes.length > 0) {
            AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext((Class[])classes);
            if (packages.length > 0) {
                applicationContext.scan(packages);
                applicationContext.refresh();
            }
            return applicationContext;
        }
        return new AnnotationConfigApplicationContext(packages);
    }
}

