/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.javaconfig.utils;

import org.jboss.arquillian.test.spi.TestClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class AnnotationApplicationContextProducer {
    public ApplicationContext createAnnotatedApplicationContext(TestClass testClass, String[] packages, Class<?>[] classes) {
        if (packages.length > 0 || classes.length > 0) {
            return this.createAnnotatedApplicationContext(classes, packages);
        }
        throw new RuntimeException("The test: " + testClass.getName() + " annotated with SpringAnnotationConfiguration must specify the configuration classes or packages.");
    }

    private ApplicationContext createAnnotatedApplicationContext(Class<?>[] classes, String[] packages) {
        if (classes.length > 0) {
            AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext((Class[])classes);
            if (packages.length > 0) {
                applicationContext.scan(packages);
                applicationContext.refresh();
            }
            return applicationContext;
        }
        return new AnnotationConfigApplicationContext(packages);
    }
}

