/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.transaction.jta.provider;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.transaction.spi.annotation.TransactionScope;
import org.jboss.arquillian.transaction.spi.provider.TransactionProvider;
import org.jboss.arquillian.transaction.spi.test.TransactionalTest;

public class JtaTransactionProvider
implements TransactionProvider {
    private static final String DEFAULT_TRANSACTION_JNDI_NAME = "java:comp/UserTransaction";
    @Inject
    private Instance<Context> jndiContextInstance;
    @Inject
    @TransactionScope
    private InstanceProducer<UserTransaction> userTransactionInstance;

    public void beginTransaction(TransactionalTest transactionalTest) {
        try {
            UserTransaction transaction = this.getUserTransaction(transactionalTest);
            this.userTransactionInstance.set((Object)transaction);
            if (this.isTransactionNotActive(transaction)) {
                transaction.begin();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to start transaction", e);
        }
    }

    public void commitTransaction(TransactionalTest transactionalTest) {
        try {
            UserTransaction transaction = (UserTransaction)this.userTransactionInstance.get();
            if (this.isTransactionMarkedToRollback(transaction)) {
                transaction.rollback();
            } else {
                transaction.commit();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to commit the transaction.", e);
        }
    }

    public void rollbackTransaction(TransactionalTest transactionalTest) {
        try {
            ((UserTransaction)this.userTransactionInstance.get()).rollback();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not rollback the transaction.", e);
        }
    }

    private UserTransaction getUserTransaction(TransactionalTest transactionalTest) {
        String jndiName = this.getJtaTransactionJndiName(transactionalTest);
        try {
            Context context = (Context)this.jndiContextInstance.get();
            if (context == null) {
                throw new RuntimeException("No Naming Context available.");
            }
            return (UserTransaction)context.lookup(jndiName);
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed obtaining transaction using [" + jndiName + "]. Is it registered under this name in your container?", e);
        }
    }

    private String getJtaTransactionJndiName(TransactionalTest transactionalTest) {
        String jndiName = DEFAULT_TRANSACTION_JNDI_NAME;
        if (transactionalTest.getManager() != null) {
            jndiName = transactionalTest.getManager();
        }
        return jndiName;
    }

    private boolean isTransactionNotActive(UserTransaction transaction) throws SystemException {
        return 6 == transaction.getStatus();
    }

    private boolean isTransactionMarkedToRollback(UserTransaction transaction) throws SystemException {
        return 1 == transaction.getStatus();
    }
}

