/**
 * JBoss, Home of Professional Open Source
 * Copyright 2013, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.arquillian.warp.impl.server.commandBus;

import org.jboss.arquillian.warp.impl.shared.command.Command;
import org.jboss.arquillian.warp.impl.shared.command.CommandPayload;
import org.jboss.arquillian.warp.impl.shared.command.CommandService;
import org.jboss.arquillian.warp.impl.utils.Rethrow;

/**
 * Performs commands on the client
 * @author Lukas Fryc
 */
public class CommandServiceOnServer implements CommandService {

    private static long TIMEOUT = 30000;

    @Override
    public <T extends Command> T execute(T operation) {
        String currentId = CommandBusOnServer.getCurrentCall();
        CommandPayload payload = new CommandPayload(operation);
        CommandBusOnServer.getEvents().put(currentId, payload);

        long timeoutTime = System.currentTimeMillis() + TIMEOUT;
        while (timeoutTime > System.currentTimeMillis()) {
           CommandPayload responsePayload = CommandBusOnServer.getEvents().get(currentId);
           if (responsePayload != null && responsePayload.isExecuted()) {
               if (responsePayload.getThrowable() != null) {
                   Rethrow.asUnchecked(responsePayload.getThrowable());
               }
               return (T) responsePayload.getCommand();
           }
           try {
              Thread.sleep(100);
           }
           catch (Exception e) {
              throw new RuntimeException(e);
           }
        }
        throw new RuntimeException("No command response within timeout of " + TIMEOUT + " ms.");
    }

}
