/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.browser;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.arquillian.ajocado.browser.BrowserType;
import org.jboss.arquillian.ajocado.selenium.SeleniumRepresentable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BrowserMode implements SeleniumRepresentable
{
    FIREFOX_PROXY(BrowserType.FIREFOX, "firefoxproxy"),
    FIREFOX(BrowserType.FIREFOX, "firefox"),
    CHROME(BrowserType.FIREFOX, "chrome"),
    FIREFOX_CHROME(BrowserType.FIREFOX, "firefoxchrome"),
    FIREFOX2(BrowserType.FIREFOX, "firefox2"),
    FIREFOX3(BrowserType.FIREFOX, "firefox3"),
    IEXPLORE_PROXY(BrowserType.IEXPLORE, "iexploreproxy"),
    SAFARI(BrowserType.SAFARI, "safari"),
    SAFARI_PROXY(BrowserType.SAFARI, "safariproxy"),
    IEXPLORE_HTA(BrowserType.IEXPLORE, "iehta"),
    IEXPLORE(BrowserType.IEXPLORE, "iexplore"),
    OPERA(BrowserType.OPERA, "opera"),
    IEXPLORE_PROXY_INJECTION(BrowserType.IEXPLORE, "piiexplore"),
    FIREFOX_PROXY_INJECTION(BrowserType.FIREFOX, "pifirefox"),
    KONQUEROR(BrowserType.KONQUEROR, "konqueror"),
    MOCK(BrowserType.MOCK, "mock"),
    GOOGLE_CHROME(BrowserType.GOOGLE_CHROME, "googlechrome"),
    SAFARI_PROXY_INJECTION(BrowserType.SAFARI, "pisafari");

    private static final Pattern PATTERN;
    private String mode;
    private BrowserType type;

    private BrowserMode(BrowserType browserType, String mode) {
        this.mode = mode;
        this.type = browserType;
    }

    public static BrowserMode parseMode(String browserMode) {
        for (BrowserMode value : BrowserMode.values()) {
            if (!value.mode.equals(browserMode)) continue;
            return value;
        }
        throw new IllegalArgumentException("The browser defined by mode '" + browserMode + "' isn't supported");
    }

    public static EnumSet<BrowserMode> parseModes(String browserModesEnumeration) {
        HashSet<BrowserMode> modes = new HashSet<BrowserMode>();
        Matcher matcher = PATTERN.matcher(browserModesEnumeration);
        while (matcher.find()) {
            String mode = matcher.group(1);
            if ("*".equals(mode)) {
                return EnumSet.allOf(BrowserMode.class);
            }
            modes.add(BrowserMode.parseMode(mode));
        }
        if (modes.isEmpty()) {
            return EnumSet.noneOf(BrowserMode.class);
        }
        return EnumSet.copyOf(modes);
    }

    public static EnumSet<BrowserMode> getModesFromTypes(EnumSet<BrowserType> types) {
        HashSet<BrowserMode> list = new HashSet<BrowserMode>();
        for (BrowserMode mode : BrowserMode.values()) {
            if (!types.contains((Object)mode.getType())) continue;
            list.add(mode);
        }
        return EnumSet.copyOf(list);
    }

    @Override
    public String inSeleniumRepresentation() {
        return "*" + this.mode;
    }

    public BrowserType getType() {
        return this.type;
    }

    static {
        PATTERN = Pattern.compile("([^, ]+)(?:[, ]+|$)");
    }
}

