/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.browser;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BrowserType {
    FIREFOX,
    IEXPLORE,
    SAFARI,
    OPERA,
    GOOGLE_CHROME,
    KONQUEROR,
    MOCK;

    private static final Pattern PATTERN;

    public static BrowserType parseType(String browserType) {
        String upperCased = browserType.toUpperCase();
        return BrowserType.valueOf(upperCased);
    }

    public static EnumSet<BrowserType> parseTypes(String browserTypesEnumeration) {
        HashSet<BrowserType> types = new HashSet<BrowserType>();
        Matcher matcher = PATTERN.matcher(browserTypesEnumeration);
        while (matcher.find()) {
            String mode = matcher.group(1);
            if ("*".equals(mode)) {
                return EnumSet.allOf(BrowserType.class);
            }
            types.add(BrowserType.parseType(mode));
        }
        if (types.isEmpty()) {
            return EnumSet.noneOf(BrowserType.class);
        }
        return EnumSet.copyOf(types);
    }

    static {
        PATTERN = Pattern.compile("([^, ]+)(?:[, ]+|$)");
    }
}

