/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.geometry;

import org.jboss.arquillian.ajocado.geometry.Offset;
import org.jboss.arquillian.ajocado.selenium.SeleniumRepresentable;

public class Point
implements SeleniumRepresentable {
    private int x;
    private int y;

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Point substract(Point point) {
        return new Point(this.x - point.x, this.y - point.y);
    }

    public Point add(Point point) {
        return new Point(this.x + point.x, this.y + point.y);
    }

    public Point substract(Offset offset) {
        return new Point(this.x - offset.getX(), this.y - offset.getY());
    }

    public Point add(Offset offset) {
        return new Point(this.x + offset.getX(), this.y + offset.getY());
    }

    public String inSeleniumRepresentation() {
        return this.x + "," + this.y;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }
}

