/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.junit.ftest;

import com.thoughtworks.selenium.SeleniumException;
import java.net.MalformedURLException;
import org.jboss.arquillian.ajocado.Graphene;
import org.jboss.arquillian.ajocado.dom.Attribute;
import org.jboss.arquillian.ajocado.junit.ftest.SampleApplication;
import org.jboss.arquillian.ajocado.locator.IdLocator;
import org.jboss.arquillian.ajocado.locator.LocatorFactory;
import org.jboss.arquillian.ajocado.locator.attribute.AttributeLocator;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class AttributePresentTestCase
extends SampleApplication {
    final IdLocator existingElement = LocatorFactory.id((String)"paragraph");
    final AttributeLocator<?> attributeExist = this.existingElement.getAttribute(Attribute.STYLE);
    final AttributeLocator<?> attributeNotExist = this.existingElement.getAttribute(Attribute.CLASS);
    final IdLocator notExistentElement = LocatorFactory.id((String)"no-such-element");
    final AttributeLocator<?> attributeOfNotExistsElement = this.notExistentElement.getAttribute(Attribute.CLASS);
    final String expectedMessage = "ERROR: element is not found";

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return AttributePresentTestCase.createDeploymentForClass(AttributePresentTestCase.class);
    }

    @Test
    public void testAttributePresent() throws MalformedURLException {
        this.openContext();
        Assert.assertTrue((boolean)this.selenium.isAttributePresent(this.attributeExist));
    }

    @Test
    public void testAttributeNotPresent() {
        this.openContext();
        Assert.assertFalse((boolean)this.selenium.isAttributePresent(this.attributeNotExist));
    }

    @Test
    public void testElementNotPresent() {
        this.openContext();
        try {
            this.selenium.isAttributePresent(this.attributeOfNotExistsElement);
            Assert.fail((String)"should raise a exception pointing that there is not such element");
        }
        catch (SeleniumException e) {
            Assert.assertTrue((String)("message was: " + e.getMessage()), (boolean)e.getMessage().startsWith("ERROR: element '"));
            Assert.assertTrue((String)("message was: " + e.getMessage()), (boolean)e.getMessage().endsWith("' is not found"));
        }
    }

    @Test
    public void testExposedMember() {
        this.openContext();
        Assert.assertTrue((boolean)Graphene.attributePresent.locator(this.attributeExist).isTrue());
        Assert.assertFalse((boolean)Graphene.attributePresent.locator(this.attributeNotExist).isTrue());
        try {
            Graphene.attributePresent.locator(this.attributeOfNotExistsElement).isTrue();
            Assert.fail((String)"should raise a exception pointing that there is not such element");
        }
        catch (SeleniumException e) {
            Assert.assertTrue((String)("message was: " + e.getMessage()), (boolean)e.getMessage().startsWith("ERROR: element '"));
            Assert.assertTrue((String)("message was: " + e.getMessage()), (boolean)e.getMessage().endsWith("' is not found"));
        }
    }
}

