/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.junit.ftest;

import org.jboss.arquillian.ajocado.Graphene;
import org.jboss.arquillian.ajocado.dom.Attribute;
import org.jboss.arquillian.ajocado.junit.ftest.SampleApplication;
import org.jboss.arquillian.ajocado.locator.JQueryLocator;
import org.jboss.arquillian.ajocado.locator.element.ElementLocator;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptRetriever;
import org.jboss.arquillian.ajocado.waiting.retrievers.AttributeRetriever;
import org.jboss.arquillian.ajocado.waiting.retrievers.TextRetriever;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class EscapingTestCase
extends SampleApplication {
    String paragraphText = "Tester's Paragraph";
    String paragraphTitle = "my paragraph's title";
    JQueryLocator paragraph = Graphene.jq((String)("p:contains('" + this.paragraphText + "')"));
    JQueryLocator div = Graphene.jq((String)"div[id=foo:bar]");
    TextRetriever retrieveParagraphText = Graphene.retrieveText.locator((ElementLocator)this.paragraph);
    AttributeRetriever retrieveParagraphTitle = Graphene.retrieveAttribute.attributeLocator(this.paragraph.getAttribute(Attribute.TITLE));

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return EscapingTestCase.createDeploymentForClass(EscapingTestCase.class);
    }

    @Test
    public void testEscapingTextRetriever() {
        this.openContext();
        Assert.assertTrue((boolean)this.selenium.isElementPresent((ElementLocator)this.paragraph));
        Assert.assertEquals((Object)Graphene.waitGui.waitForChangeAndReturn((Object)"unknown", (JavaScriptRetriever)this.retrieveParagraphText), (Object)this.paragraphText);
    }

    @Test
    public void testEscapingAttributeRetriever() {
        this.openContext();
        Assert.assertTrue((boolean)this.selenium.isElementPresent((ElementLocator)this.paragraph));
        Assert.assertEquals((Object)Graphene.waitGui.waitForChangeAndReturn((Object)"unknown", (JavaScriptRetriever)this.retrieveParagraphTitle), (Object)this.paragraphTitle);
    }

    @Test
    public void testEscapingLocatorAttribute() {
        Assert.assertTrue((String)"Wrong escaping of locator when using not permitted chars!", (boolean)this.selenium.isElementPresent((ElementLocator)this.div));
    }
}

