/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.junit.ftest;

import org.jboss.arquillian.ajocado.Graphene;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.guard.RequestGuardException;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.junit.ftest.SampleApplication;
import org.jboss.arquillian.ajocado.locator.element.ElementLocator;
import org.jboss.arquillian.ajocado.request.RequestType;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class RequestGuardTestCase
extends SampleApplication {
    private JavaScript twoClicksWithTimeout = JavaScript.fromResource((String)"two-clicks-with-timeout.js");
    private ElementLocator<?> linkNoRequest = Graphene.id((String)"noRequest");
    private ElementLocator<?> linkAjaxRequest = Graphene.id((String)"ajax");
    private ElementLocator<?> linkHttpRequest = Graphene.id((String)"http");

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return RequestGuardTestCase.createDeploymentForClass(RequestGuardTestCase.class);
    }

    @Test
    public void testGuardNone() {
        this.openContext();
        Graphene.guardNoRequest((GrapheneSelenium)this.selenium).click(this.linkNoRequest);
    }

    @Test
    public void testGuardNoneButHttpDone() {
        this.openContext();
        try {
            Graphene.guardNoRequest((GrapheneSelenium)this.selenium).click(this.linkHttpRequest);
            Assert.fail((String)"The NO request was observed, however HTTP request was expected");
        }
        catch (RequestGuardException e) {
            Assert.assertTrue((e.getRequestDone() == RequestType.HTTP ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGuardNoneButXhrDone() {
        this.openContext();
        try {
            Graphene.guardNoRequest((GrapheneSelenium)this.selenium).click(this.linkAjaxRequest);
            Assert.fail((String)"The NO request was observed, however XHR request was expected");
        }
        catch (RequestGuardException e) {
            Assert.assertTrue((e.getRequestDone() == RequestType.XHR ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGuardHttp() {
        this.openContext();
        Graphene.guardHttp((GrapheneSelenium)this.selenium).click(this.linkHttpRequest);
    }

    @Test
    public void testGuardHttpButNoneDone() {
        this.openContext();
        try {
            Graphene.guardHttp((GrapheneSelenium)this.selenium).click(this.linkNoRequest);
            Assert.fail((String)"The HTTP request was observed, however NONE request was expected");
        }
        catch (RequestGuardException e) {
            Assert.assertTrue((String)("NONE request expected, but " + e.getRequestDone() + " was done"), (e.getRequestDone() == RequestType.NONE ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGuardHttpButXhrDone() {
        this.openContext();
        try {
            Graphene.guardHttp((GrapheneSelenium)this.selenium).click(this.linkAjaxRequest);
            Assert.fail((String)"The HTTP request was observed, however XHR request was expected");
        }
        catch (RequestGuardException e) {
            Assert.assertTrue((String)("XHR request expected, but " + e.getRequestDone() + " was done"), (e.getRequestDone() == RequestType.XHR ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGuardXhr() {
        this.openContext();
        Graphene.guardXhr((GrapheneSelenium)this.selenium).click(this.linkAjaxRequest);
    }

    @Test
    public void testGuardXhrButNoneDone() {
        this.openContext();
        try {
            Graphene.guardXhr((GrapheneSelenium)this.selenium).click(this.linkNoRequest);
            Assert.fail((String)"The XHR request was observed, however NONE request was expected");
        }
        catch (RequestGuardException e) {
            Assert.assertTrue((e.getRequestDone() == RequestType.NONE ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGuardXhrButHttpDone() {
        this.openContext();
        try {
            Graphene.guardXhr((GrapheneSelenium)this.selenium).click(this.linkHttpRequest);
            Assert.fail((String)"The XHR request was observed, however HTTP request was expected");
        }
        catch (RequestGuardException e) {
            Assert.assertTrue((e.getRequestDone() == RequestType.HTTP ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWaitForXhr() {
        this.openContext();
        Graphene.waitForXhr((GrapheneSelenium)this.selenium).getEval(this.twoClicksWithTimeout.parametrize(new Object[]{this.linkHttpRequest, this.linkAjaxRequest}));
    }

    @Test
    public void testWaitXhrButNoneAndHttpDone() {
        this.openContext();
        try {
            Graphene.waitForXhr((GrapheneSelenium)this.selenium).getEval(this.twoClicksWithTimeout.parametrize(new Object[]{this.linkHttpRequest, this.linkNoRequest}));
            Assert.fail();
        }
        catch (RequestGuardException e) {
            Assert.assertTrue((e.getRequestDone() == RequestType.HTTP ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWaitXhrButTwoHttpDone() {
        this.openContext();
        try {
            Graphene.waitForXhr((GrapheneSelenium)this.selenium).getEval(this.twoClicksWithTimeout.parametrize(new Object[]{this.linkHttpRequest, this.linkHttpRequest}));
            Assert.fail();
        }
        catch (RequestGuardException e) {
            Assert.assertTrue((e.getRequestDone() == RequestType.HTTP ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWaitHttp() {
        this.openContext();
        Graphene.waitForHttp((GrapheneSelenium)this.selenium).getEval(this.twoClicksWithTimeout.parametrize(new Object[]{this.linkAjaxRequest, this.linkHttpRequest}));
    }

    @Test
    public void testWaitHttpButNoneAndXhrDone() {
        this.openContext();
        try {
            Graphene.waitForHttp((GrapheneSelenium)this.selenium).getEval(this.twoClicksWithTimeout.parametrize(new Object[]{this.linkAjaxRequest, this.linkNoRequest}));
            Assert.fail();
        }
        catch (RequestGuardException e) {
            Assert.assertTrue((e.getRequestDone() == RequestType.XHR ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWaitHttpButTwoXhrDone() {
        this.openContext();
        try {
            Graphene.waitForHttp((GrapheneSelenium)this.selenium).getEval(this.twoClicksWithTimeout.parametrize(new Object[]{this.linkAjaxRequest, this.linkAjaxRequest}));
            Assert.fail();
        }
        catch (RequestGuardException e) {
            Assert.assertTrue((e.getRequestDone() == RequestType.XHR ? 1 : 0) != 0);
        }
    }
}

