/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.drone.factory;

import org.jboss.arquillian.ajocado.drone.factory.AbstractDroneTestCase;
import org.jboss.arquillian.ajocado.drone.factory.TestingDriverConfiguration;
import org.jboss.arquillian.ajocado.drone.factory.TestingDriverFactory;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.TypedWebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.context.TestingDriver;
import org.jboss.arquillian.graphene.drone.factory.GrapheneWebDriverFactory;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.openqa.selenium.WebDriver;

@RunWith(value=MockitoJUnitRunner.class)
public class GrapheneWebDriverFactoryTestCase
extends AbstractDroneTestCase {
    @Inject
    private Instance<Injector> injector;
    @Mock
    private TypedWebDriverConfiguration<WebDriverConfiguration> configuration;
    GrapheneWebDriverFactory factory = new GrapheneWebDriverFactory();
    TestingFactory testingFactory = new TestingFactory();
    @Mock
    TestingDriver realDriver;
    @Mock(extraInterfaces={GrapheneProxyInstance.class})
    TestingDriver proxyDriver;

    @Before
    public void init() {
        ((Injector)this.injector.get()).inject((Object)this.factory);
        this.addAllServices(Instantiator.class, this.factory, this.testingFactory);
        this.getManager().fire((Object)new BeforeSuite());
    }

    @Test
    public void when_instantiator_creates_driver_instance_then_proxy_instance_is_returned_by_factory() {
        this.given_instantiator_creates(this.realDriver);
        WebDriver createdDriver = this.factory.createInstance(this.configuration);
        Assert.assertTrue((boolean)(createdDriver instanceof GrapheneProxyInstance));
        Assert.assertNotSame((Object)createdDriver, (Object)this.realDriver);
    }

    @Test
    public void when_instantiator_creates_driver_instance_then_factory_set_it_to_context() {
        this.given_instantiator_creates(this.realDriver);
        WebDriver createdDriver = this.factory.createInstance(this.configuration);
        createdDriver.getCurrentUrl();
        Assert.assertTrue((boolean)GrapheneContext.isInitialized());
        ((TestingDriver)Mockito.verify((Object)this.realDriver, (VerificationMode)Mockito.only())).getCurrentUrl();
    }

    @Test
    public void when_instantiator_creates_proxy_then_factory_simply_return_it() {
        this.given_instantiator_creates(this.proxyDriver);
        WebDriver createdDriver = this.factory.createInstance(this.configuration);
        Assert.assertTrue((boolean)(createdDriver instanceof GrapheneProxyInstance));
        Assert.assertSame((Object)createdDriver, (Object)this.proxyDriver);
    }

    private void given_instantiator_creates(TestingDriver driver) {
        Mockito.when((Object)this.configuration.getImplementationClass()).thenReturn((Object)TestingDriver.class.getName());
        this.testingFactory.setInstance(driver);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TestingFactory
    extends TestingDriverFactory
    implements Configurator<TestingDriver, TypedWebDriverConfiguration<TestingDriverConfiguration>>,
    Instantiator<TestingDriver, TypedWebDriverConfiguration<TestingDriverConfiguration>>,
    Destructor<TestingDriver> {
        private TestingDriver instance;

        public void setInstance(TestingDriver instance) {
            this.instance = instance;
        }

        @Override
        public TestingDriver createInstance(TypedWebDriverConfiguration<TestingDriverConfiguration> configuration) {
            return this.instance;
        }
    }
}

