/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.drone.factory;

import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.FirefoxDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.configuration.TypedWebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.FirefoxDriverFactory;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrapheneFirefoxDriverFactory
extends FirefoxDriverFactory
implements Configurator<FirefoxDriver, TypedWebDriverConfiguration<FirefoxDriverConfiguration>>,
Instantiator<FirefoxDriver, TypedWebDriverConfiguration<FirefoxDriverConfiguration>>,
Destructor<FirefoxDriver> {
    public int getPrecedence() {
        return 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyInstance(FirefoxDriver instance) {
        try {
            super.destroyInstance(instance);
        }
        finally {
            GrapheneContext.reset();
        }
    }

    public FirefoxDriver createInstance(TypedWebDriverConfiguration<FirefoxDriverConfiguration> configuration) {
        FirefoxDriver driver = super.createInstance(configuration);
        FirefoxDriver proxy = (FirefoxDriver)GrapheneContext.getProxyForDriver(FirefoxDriver.class);
        GrapheneContext.set((WebDriver)driver);
        return proxy;
    }
}

