/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.guard;

import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.graphene.javascript.JSInterfaceFactory;
import org.jboss.arquillian.graphene.request.RequestGuard;
import org.jboss.arquillian.graphene.request.RequestType;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
@RunAsClient
public class RequestGuardTestCase {
    @ArquillianResource
    private URL contextRoot;
    @Drone
    private WebDriver browser;
    @FindBy(id="xhr")
    private WebElement xhr;
    @FindBy(id="http")
    private WebElement http;
    @FindBy(id="status")
    private WebElement status;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("sample1.html").loadPage(this.browser, this.contextRoot);
    }

    @Test
    public void testXhr() throws InterruptedException {
        RequestGuard guard = (RequestGuard)JSInterfaceFactory.create((GrapheneContext)GrapheneContext.getContextFor(Default.class), RequestGuard.class);
        Assert.assertEquals((Object)RequestType.HTTP, (Object)guard.getRequestType());
        guard.clearRequestDone();
        Assert.assertEquals((Object)RequestType.NONE, (Object)guard.getRequestType());
        this.xhr.click();
        Graphene.waitAjax().until().element(this.status).text().contains("DONE");
        Assert.assertEquals((Object)RequestType.XHR, (Object)guard.getRequestType());
    }

    @Test
    public void testHttp() {
        RequestGuard guard = (RequestGuard)JSInterfaceFactory.create((GrapheneContext)GrapheneContext.getContextFor(Default.class), RequestGuard.class);
        Assert.assertEquals((Object)RequestType.HTTP, (Object)guard.getRequestType());
        guard.clearRequestDone();
        Assert.assertEquals((Object)RequestType.NONE, (Object)guard.getRequestType());
        this.http.click();
        Assert.assertEquals((Object)RequestType.HTTP, (Object)guard.getRequestType());
    }
}

