/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.intercept;

import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;

@RunWith(value=Arquillian.class)
public class TestInterceptorSetupIsolation {
    @Drone
    private WebDriver browser;
    private boolean invoked = false;

    @Before
    public void resetFlags() {
        this.invoked = false;
    }

    @Test
    @InSequence(value=1)
    public void interceptor_can_be_registered_in_test_itself() {
        ((GrapheneProxyInstance)this.browser).registerInterceptor(new Interceptor(){

            public Object intercept(InvocationContext context) throws Throwable {
                TestInterceptorSetupIsolation.this.invoked = true;
                return context.invoke();
            }
        });
        Assert.assertFalse((boolean)this.invoked);
        this.browser.get("about:blank");
        Assert.assertTrue((boolean)this.invoked);
    }

    @Test
    @InSequence(value=2)
    public void interceptors_arent_shared_across_tests() {
        Assert.assertFalse((boolean)this.invoked);
        this.browser.get("about:blank");
        Assert.assertFalse((boolean)this.invoked);
    }
}

