/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.enricher;

import java.net.URL;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.graphene.javascript.Dependency;
import org.jboss.arquillian.graphene.javascript.JavaScript;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
@RunAsClient
public class TestGrapheneElement {
    @Drone
    private WebDriver browser;
    @FindBy
    private GrapheneElement root;
    @FindBy(id="root")
    private WebElement pureRoot;
    @FindBy
    private GrapheneElement doesntExist;
    @FindBy
    private List<GrapheneElement> doesntExistList;
    @FindBy(tagName="option")
    private List<GrapheneElement> options;
    @FindBy(tagName="option")
    private List<WebElement> pureOptions;
    @JavaScript
    private TestJavascript testJavascript;
    @ArquillianResource
    private Actions actions;
    @ArquillianResource
    private URL contextRoot;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("sample.html").loadPage(this.browser, this.contextRoot);
    }

    @Test
    public void testOneIsPresent() {
        Assert.assertTrue((boolean)this.root.isPresent());
        Assert.assertFalse((boolean)this.doesntExist.isPresent());
    }

    @Test
    public void testOneGetText() {
        Assert.assertEquals((Object)this.pureRoot.getText().trim(), (Object)this.root.getText().trim());
    }

    @Test
    public void testOneWithJavascript() {
        String inner = this.testJavascript.getInnerHtml((WebElement)this.root);
        inner = inner.replaceAll("\"", "").toLowerCase();
        Assert.assertThat((Object)inner, (Matcher)Matchers.containsString((String)"<div id=pseudoroot>pseudo root</div>"));
    }

    @Test
    public void testOneWithActions() {
        this.actions.moveToElement((WebElement)this.root).doubleClick().build().perform();
    }

    @Test
    public void testOneFindByTagName() {
        GrapheneElement element = this.root.findElement(By.tagName((String)"div"));
        Assert.assertEquals((Object)"pseudo root", (Object)element.getText().trim());
    }

    @Test
    public void testOneFindByCss() {
        GrapheneElement element = this.root.findElement(By.cssSelector((String)"div"));
        Assert.assertEquals((Object)"pseudo root", (Object)element.getText().trim());
    }

    @Test
    public void testOneFindByJQuery() {
        GrapheneElement element = this.root.findElement((By)ByJQuery.selector((String)"div"));
        Assert.assertEquals((Object)"pseudo root", (Object)element.getText().trim());
    }

    @Test
    public void testListIsPresent() {
        Assert.assertEquals((long)3L, (long)this.options.size());
        for (GrapheneElement element : this.options) {
            Assert.assertTrue((boolean)element.isPresent());
        }
        Assert.assertEquals((long)0L, (long)this.doesntExistList.size());
    }

    @Test
    public void testListGetText() {
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((Object)this.pureOptions.get(i).getText().trim(), (Object)this.options.get(i).getText());
        }
    }

    @Test
    public void testListWithJavascript() {
        for (GrapheneElement element : this.options) {
            String inner = this.testJavascript.getInnerHtml((WebElement)element);
            Assert.assertTrue((boolean)inner.contains("option"));
        }
    }

    @JavaScript(value="document.test")
    @Dependency(sources={"org/jboss/arquillian/graphene/ftest/enricher/test.js"})
    public static interface TestJavascript {
        public String getInnerHtml(WebElement var1);
    }
}

