/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.intercept;

import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.ftest.intercept.InterceptorRegistrationExtension;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;

@RunWith(value=Arquillian.class)
public class TestInterceptorRegistration {
    @Drone
    private WebDriver browser;
    private boolean interceptor_registered_before_test_invoked = false;

    @Before
    public void resetFlags() {
        this.interceptor_registered_before_test_invoked = false;
    }

    @Before
    public void register_interceptor_before_test() {
        ((GrapheneProxyInstance)this.browser).registerInterceptor(new Interceptor(){

            public Object intercept(InvocationContext context) throws Throwable {
                TestInterceptorRegistration.this.interceptor_registered_before_test_invoked = true;
                return context.invoke();
            }
        });
    }

    @Test
    public void interceptor_can_be_registered_before_test() {
        Assert.assertFalse((boolean)this.interceptor_registered_before_test_invoked);
        this.browser.get("about:blank");
        Assert.assertTrue((boolean)this.interceptor_registered_before_test_invoked);
    }

    @Test
    public void interceptor_can_be_registered_by_extension_before_test() {
        Assert.assertFalse((boolean)InterceptorRegistrationExtension.invoked);
        this.browser.get("about:blank");
        Assert.assertTrue((boolean)InterceptorRegistrationExtension.invoked);
    }
}

