/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.wait;

import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.ftest.wait.AbstractWaitTest;
import org.junit.Test;
import org.openqa.selenium.TimeoutException;

public class WebDriverWaitTest
extends AbstractWaitTest {
    @Test
    public void testMessageUntil() {
        String message = "blah blah blah blah blah";
        try {
            Graphene.waitGui().until(message).element(BY_HEADER).text().equalTo("sjkldhkdjfgjlkfg");
            Assert.fail((String)(TimeoutException.class.getName() + " should be thrown."));
        }
        catch (TimeoutException e) {
            Assert.assertTrue((String)("The exception message <" + e.getMessage() + "> should contain message <" + message + "> defined by 'withMessage()' method"), (boolean)e.getMessage().contains(message));
        }
    }

    @Test
    public void testWithMessage() {
        String message = "blah blah blah blah blah";
        try {
            Graphene.waitGui().withMessage(message).until().element(BY_HEADER).text().equalTo("sjkldhkdjfgjlkfg");
            Assert.fail((String)(TimeoutException.class.getName() + " should be thrown."));
        }
        catch (TimeoutException e) {
            Assert.assertTrue((String)("The exception message <" + e.getMessage() + "> should contain message <" + message + "> defined by 'withMessage()' method"), (boolean)e.getMessage().contains(message));
        }
    }

    @Test
    public void testWithMessageAndMessageUntil() {
        String message = "blah blah blah blah blah";
        try {
            Graphene.waitGui().withMessage("srhjkfsdbhfjkfbsdnbfm,sndbsdmnbf").until(message).element(BY_HEADER).text().equalTo("sjkldhkdjfgjlkfg");
            Assert.fail((String)(TimeoutException.class.getName() + " should be thrown."));
        }
        catch (TimeoutException e) {
            Assert.assertTrue((String)("The exception message <" + e.getMessage() + "> should contain message <" + message + "> defined by 'withMessage()' method"), (boolean)e.getMessage().contains(message));
        }
    }

    @Test
    public void testWithTimeout() {
        TimeUnit unit = TimeUnit.MILLISECONDS;
        long duration = 2000L;
        long started = System.currentTimeMillis();
        try {
            Graphene.waitModel().withTimeout(duration, unit).until().element(BY_HEADER).text().equalTo("sjkldhkdjfgjlkfg");
            Assert.fail((String)(TimeoutException.class.getName() + " should be thrown."));
        }
        catch (TimeoutException e) {
            long was = System.currentTimeMillis() - started;
            Assert.assertTrue((String)("The waiting time shouldn't be much bigger than " + duration + " " + (Object)((Object)unit) + ", but was " + was + " ms."), (was < unit.toMillis(duration + duration / 2L) ? 1 : 0) != 0);
            Assert.assertTrue((String)("The waiting time shouldn't lower than " + duration + " " + (Object)((Object)unit) + ", but was " + was + " ms."), (was >= unit.toMillis(duration) ? 1 : 0) != 0);
        }
    }
}

