/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.enricher;

import java.net.URL;
import junit.framework.Assert;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.fragment.Root;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

@RunWith(value=Arquillian.class)
@RunAsClient
public class TestSamplePageFragment {
    @Drone
    private WebDriver browser;
    @FindBy(id="root")
    private SamplePageFragment pageFragment;
    @FindBy(id="root")
    private SamplePageFragmentWithRootAsTheLastField pageFragmentWithRootAsTheLastField;
    @FindBy(id="span")
    private WebElement spanNotCorrect;
    @ArquillianResource
    private URL contextRoot;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("sample.html").loadPage(this.browser, this.contextRoot);
    }

    @Test
    public void testRelativePath() {
        Assert.assertEquals((String)"Fields in page fragment are not initialized relatively to root element.", (String)"correct", (String)this.pageFragment.getText().toLowerCase().trim());
    }

    @Test
    public void testNotStandardOrder() {
        Assert.assertEquals((String)"pseudo root", (String)this.pageFragmentWithRootAsTheLastField.getPseudoroot().getText().toLowerCase().trim());
        Assert.assertTrue((boolean)this.pageFragmentWithRootAsTheLastField.getRoot().getText().toLowerCase().trim().contains("pseudo root"));
        Assert.assertFalse((boolean)this.pageFragmentWithRootAsTheLastField.getRoot().getText().toLowerCase().trim().equals("pseudo root"));
    }

    public void testCommonWebElement() {
        Assert.assertEquals((String)"not correct", (String)this.spanNotCorrect.getText().toLowerCase().trim());
    }

    public static class SamplePageFragmentWithRootAsTheLastField {
        @FindBy(id="pseudoroot")
        private WebElement pseudoroot;
        @Root
        private WebElement root;

        public WebElement getRoot() {
            return this.root;
        }

        public WebElement getPseudoroot() {
            return this.pseudoroot;
        }
    }

    public static class SamplePageFragment {
        @Root
        private WebElement root;
        @FindBy(tagName="span")
        private WebElement span;

        public String getText() {
            return this.span.getText();
        }
    }
}

