/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.javascript;

import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.graphene.javascript.Dependency;
import org.jboss.arquillian.graphene.javascript.JavaScript;
import org.jboss.arquillian.graphene.page.document.Document;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@RunWith(value=Arquillian.class)
@RunAsClient
public class EnrichmentTestCase {
    @ArquillianResource
    private URL contextRoot;
    @Drone
    private WebDriver browser;
    @JavaScript
    private Document document;
    @JavaScript
    private Screen screen;
    @JavaScript
    private Unstable unstable;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("sample.html").loadPage(this.browser, this.contextRoot);
    }

    @Test
    public void testNotNull() {
        Assert.assertNotNull((Object)this.document);
        Assert.assertNotNull((Object)this.screen);
    }

    @Test
    public void testDocumentMethods() {
        Assert.assertEquals((Object)"Hello World!", (Object)((WebElement)this.document.getElementsByTagName("h1").get(0)).getText());
    }

    @Test
    public void testScreenMethods() {
        Assert.assertNotNull((Object)this.screen.getHeight());
        Assert.assertNotNull((Object)this.screen.getWidth());
    }

    @Test
    public void testUnstable() {
        try {
            Assert.assertNotNull((String)"The return value can't be null.", (Object)this.unstable.simple());
            Assert.assertNotNull((String)"The return value can't be null.", (Object)this.unstable.simple());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            Assert.fail((String)("Can't invoke unstable javascript extension: " + e.getMessage()));
        }
    }

    @JavaScript(value="document.unstable")
    @Dependency(sources={"org/jboss/arquillian/graphene/ftest/javascript/unstable.js"})
    public static interface Unstable {
        public Long simple();
    }

    @JavaScript(value="window.screen")
    public static interface Screen {
        public Long getWidth();

        public Long getHeight();
    }
}

