/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.ftest.javascript;

import java.net.URL;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.ftest.Resource;
import org.jboss.arquillian.graphene.ftest.Resources;
import org.jboss.arquillian.graphene.javascript.Dependency;
import org.jboss.arquillian.graphene.javascript.InstallableJavaScript;
import org.jboss.arquillian.graphene.javascript.JSInterfaceFactory;
import org.jboss.arquillian.graphene.javascript.JavaScript;
import org.jboss.arquillian.graphene.page.document.Document;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsElement;

@RunWith(value=Arquillian.class)
@RunAsClient
public class JavaScriptPageExtensionTestCase {
    @ArquillianResource
    private URL contextRoot;
    @Drone
    private WebDriver browser;
    @ArquillianResource
    private GrapheneContext context;

    @Deployment
    public static WebArchive createTestArchive() {
        return Resources.inCurrentPackage().all().buildWar("test.war");
    }

    @Before
    public void loadPage() {
        Resource.inCurrentPackage().find("sample.html").loadPage(this.browser, this.contextRoot);
    }

    @Test
    public void testWithoutSources() {
        Document document = (Document)JSInterfaceFactory.create((GrapheneContext)this.context, Document.class);
        List elements = document.getElementsByTagName("html");
        Assert.assertNotNull((Object)elements);
        Assert.assertEquals((long)1L, (long)elements.size());
    }

    @Test
    public void testWithSources() {
        HelloWorld helloWorld = (HelloWorld)JSInterfaceFactory.create((GrapheneContext)this.context, HelloWorld.class);
        Assert.assertEquals((Object)"Hello World!", (Object)helloWorld.hello());
    }

    @Test
    public void testWithInterfaceDependencies() {
        HelloWorld2 helloWorld = (HelloWorld2)JSInterfaceFactory.create((GrapheneContext)this.context, HelloWorld2.class);
        Assert.assertEquals((Object)"Hello World!", (Object)helloWorld.hello());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWithoutSourceAndWithInterfaceDependencies() {
        ((Document2)JSInterfaceFactory.create((GrapheneContext)this.context, Document2.class)).getTitle();
    }

    @Test
    public void testAbstractClass() {
        Document3 document = (Document3)JSInterfaceFactory.create((GrapheneContext)this.context, Document3.class);
        WebElement element = this.unwrapWebElement(this.browser.findElement(By.tagName((String)"h1")));
        Assert.assertEquals((Object)element, (Object)document.getHeader());
    }

    private WebElement unwrapWebElement(WebElement element) {
        while (element instanceof WrapsElement) {
            element = ((WrapsElement)element).getWrappedElement();
        }
        return element;
    }

    @JavaScript(value="document.helloworld2")
    @Dependency(sources={"org/jboss/arquillian/graphene/ftest/javascript/hello-world2.js"}, interfaces={HelloWorld.class})
    public static interface HelloWorld2 {
        public String hello();
    }

    @JavaScript(value="document.helloworld")
    @Dependency(sources={"org/jboss/arquillian/graphene/ftest/javascript/hello-world.js"})
    public static interface HelloWorld
    extends InstallableJavaScript {
        public String hello();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @JavaScript(value="document")
    public abstract class Document3 {
        public abstract List<WebElement> getElementsByTagName(String var1);

        public WebElement getHeader() {
            List<WebElement> elements = this.getElementsByTagName("h1");
            if (elements.iterator().hasNext()) {
                return elements.iterator().next();
            }
            return null;
        }
    }

    @JavaScript(value="fake")
    @Dependency(interfaces={HelloWorld.class})
    public static interface Document2 {
        public String getTitle();
    }
}

